/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.vehicles;

import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentcs.components.Lifecycle;
import org.opentcs.components.kernel.services.PeripheralDispatcherService;
import org.opentcs.components.kernel.services.PeripheralJobService;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.data.peripherals.PeripheralOperation;
import org.opentcs.drivers.vehicle.MovementCommand;
import org.opentcs.kernel.vehicles.PeripheralInteraction;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.event.EventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralInteractor
implements EventHandler,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralInteractor.class);
    private final TCSObjectReference<Vehicle> vehicleRef;
    private final PeripheralJobService peripheralJobService;
    private final PeripheralDispatcherService peripheralDispatcherService;
    private final EventSource eventSource;
    private final Map<MovementCommand, PeripheralInteraction> preMovementInteractions = new HashMap<MovementCommand, PeripheralInteraction>();
    private final Map<MovementCommand, PeripheralInteraction> postMovementInteractions = new HashMap<MovementCommand, PeripheralInteraction>();
    private boolean initialized;

    @Inject
    public PeripheralInteractor(@Assisted @Nonnull TCSObjectReference<Vehicle> vehicleRef, @Nonnull PeripheralJobService peripheralJobService, @Nonnull PeripheralDispatcherService peripheralDispatcherService, @Nonnull @ApplicationEventBus EventSource eventSource) {
        this.vehicleRef = Objects.requireNonNull(vehicleRef, "vehicleRef");
        this.peripheralJobService = Objects.requireNonNull(peripheralJobService, "peripheralJobService");
        this.peripheralDispatcherService = Objects.requireNonNull(peripheralDispatcherService, "peripheralDispatcherService");
        this.eventSource = Objects.requireNonNull(eventSource, "eventSource");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.eventSource.subscribe((EventHandler)this);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.eventSource.unsubscribe((EventHandler)this);
        this.initialized = false;
    }

    public void onEvent(Object event) {
        if (!(event instanceof TCSObjectEvent)) {
            return;
        }
        TCSObjectEvent objectEvent = (TCSObjectEvent)event;
        if (objectEvent.getType() != TCSObjectEvent.Type.OBJECT_MODIFIED) {
            return;
        }
        if (objectEvent.getCurrentOrPreviousObjectState() instanceof PeripheralJob) {
            this.onPeripheralJobChange(objectEvent);
        }
    }

    public void prepareInteractions(TCSObjectReference<TransportOrder> orderRef, MovementCommand movementCommand) {
        List<PeripheralOperation> postMovementOperations;
        Path path = movementCommand.getStep().getPath();
        if (path == null) {
            return;
        }
        Map<PeripheralOperation.ExecutionTrigger, List<PeripheralOperation>> operations = path.getPeripheralOperations().stream().collect(Collectors.groupingBy(t -> t.getExecutionTrigger()));
        operations.computeIfAbsent(PeripheralOperation.ExecutionTrigger.BEFORE_MOVEMENT, executionTrigger -> new ArrayList());
        operations.computeIfAbsent(PeripheralOperation.ExecutionTrigger.AFTER_MOVEMENT, executionTrigger -> new ArrayList());
        String reservationToken = this.determineReservationToken();
        List<PeripheralOperation> preMovementOperations = operations.get(PeripheralOperation.ExecutionTrigger.BEFORE_MOVEMENT);
        if (!preMovementOperations.isEmpty()) {
            this.preMovementInteractions.put(movementCommand, new PeripheralInteraction(this.vehicleRef, orderRef, movementCommand, preMovementOperations, this.peripheralJobService, reservationToken));
        }
        if (!(postMovementOperations = operations.get(PeripheralOperation.ExecutionTrigger.AFTER_MOVEMENT)).isEmpty()) {
            this.postMovementInteractions.put(movementCommand, new PeripheralInteraction(this.vehicleRef, orderRef, movementCommand, postMovementOperations, this.peripheralJobService, reservationToken));
        }
    }

    public void startPreMovementInteractions(@Nonnull MovementCommand movementCommand, @Nonnull Runnable succeededCallback, @Nonnull Runnable failedCallback) {
        Objects.requireNonNull(movementCommand, "movementCommand");
        Objects.requireNonNull(succeededCallback, "succeededCallback");
        Objects.requireNonNull(failedCallback, "failedCallback");
        if (!this.preMovementInteractions.containsKey(movementCommand)) {
            LOG.debug("{}: No interactions to be performed before movement to {}...", (Object)this.vehicleRef.getName(), (Object)movementCommand.getStep().getDestinationPoint().getName());
            succeededCallback.run();
            return;
        }
        LOG.debug("{}: There are interactions to be performed before movement to {}...", (Object)this.vehicleRef.getName(), (Object)movementCommand.getStep().getDestinationPoint().getName());
        this.preMovementInteractions.get(movementCommand).start(succeededCallback, failedCallback);
        if (this.preMovementInteractions.get(movementCommand).isFinished()) {
            this.preMovementInteractions.remove(movementCommand);
        }
        this.peripheralDispatcherService.dispatch();
    }

    public void startPostMovementInteractions(@Nonnull MovementCommand movementCommand, @Nonnull Runnable succeededCallback, @Nonnull Runnable failedCallback) {
        Objects.requireNonNull(movementCommand, "movementCommand");
        Objects.requireNonNull(succeededCallback, "succeededCallback");
        Objects.requireNonNull(failedCallback, "failedCallback");
        if (!this.postMovementInteractions.containsKey(movementCommand)) {
            LOG.debug("{}: No interactions to be performed after movement to {}...", (Object)this.vehicleRef.getName(), (Object)movementCommand.getStep().getDestinationPoint().getName());
            succeededCallback.run();
            return;
        }
        LOG.debug("{}: There are interactions to be performed after movement to {}...", (Object)this.vehicleRef.getName(), (Object)movementCommand.getStep().getDestinationPoint().getName());
        this.postMovementInteractions.get(movementCommand).start(succeededCallback, failedCallback);
        if (this.postMovementInteractions.get(movementCommand).isFinished()) {
            this.postMovementInteractions.remove(movementCommand);
        }
        this.peripheralDispatcherService.dispatch();
    }

    public boolean isWaitingForMovementInteractionsToFinish() {
        return this.isWaitingForPreMovementInteractionsToFinish() || this.isWaitingForPostMovementInteractionsToFinish();
    }

    public boolean isWaitingForPreMovementInteractionsToFinish() {
        return !this.preMovementInteractions.values().stream().filter(PeripheralInteraction::hasRequiredOperations).allMatch(PeripheralInteraction::isFinished);
    }

    public boolean isWaitingForPostMovementInteractionsToFinish() {
        return !this.postMovementInteractions.values().stream().filter(PeripheralInteraction::hasRequiredOperations).allMatch(PeripheralInteraction::isFinished);
    }

    public Map<String, List<PeripheralOperation>> pendingRequiredInteractionsByDestination() {
        return Stream.concat(this.preMovementInteractions.entrySet().stream(), this.postMovementInteractions.entrySet().stream()).map(entry -> (PeripheralInteraction)entry.getValue()).filter(interaction -> interaction.hasRequiredOperations()).collect(Collectors.groupingBy(interact -> interact.getMovementCommand().getStep().getDestinationPoint().getName(), Collectors.flatMapping(interaction -> interaction.getPendingRequiredOperations().stream(), Collectors.toList())));
    }

    private void onPeripheralJobChange(TCSObjectEvent event) {
        PeripheralJob prevJobState = (PeripheralJob)event.getPreviousObjectState();
        PeripheralJob currJobState = (PeripheralJob)event.getCurrentObjectState();
        if (prevJobState.getState() != currJobState.getState()) {
            switch (currJobState.getState()) {
                case FINISHED: {
                    this.onPeripheralJobFinished(currJobState);
                    break;
                }
                case FAILED: {
                    this.onPeripheralJobFailed(currJobState);
                    break;
                }
            }
        }
    }

    private void onPeripheralJobFinished(PeripheralJob job) {
        Stream.concat(this.preMovementInteractions.values().stream(), this.postMovementInteractions.values().stream()).forEach(interaction -> interaction.onPeripheralJobFinished(job));
        Set<MovementCommand> preMovementsPrepared = this.preMovementInteractions.entrySet().stream().filter(entry -> ((PeripheralInteraction)entry.getValue()).isFinished()).map(entry -> (MovementCommand)entry.getKey()).collect(Collectors.toSet());
        Set<MovementCommand> postMovementsPrepared = this.postMovementInteractions.entrySet().stream().filter(entry -> ((PeripheralInteraction)entry.getValue()).isFinished()).map(entry -> (MovementCommand)entry.getKey()).collect(Collectors.toSet());
        preMovementsPrepared.forEach(movementCommand -> this.preMovementInteractions.remove(movementCommand));
        postMovementsPrepared.forEach(movementCommand -> this.postMovementInteractions.remove(movementCommand));
    }

    private void onPeripheralJobFailed(PeripheralJob job) {
        Stream.concat(this.preMovementInteractions.values().stream(), this.postMovementInteractions.values().stream()).forEach(interaction -> interaction.onPeripheralJobFailed(job));
    }

    public void clear() {
        this.preMovementInteractions.clear();
        this.postMovementInteractions.clear();
    }

    private String determineReservationToken() {
        TransportOrder transportOrder;
        Vehicle vehicle = (Vehicle)this.peripheralJobService.fetchObject(Vehicle.class, this.vehicleRef);
        if (vehicle.getTransportOrder() != null && (transportOrder = (TransportOrder)this.peripheralJobService.fetchObject(TransportOrder.class, vehicle.getTransportOrder())).getPeripheralReservationToken() != null) {
            return transportOrder.getPeripheralReservationToken();
        }
        return vehicle.getName();
    }
}

