/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.vehicles;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Point;
import org.opentcs.data.order.Route;
import org.opentcs.drivers.vehicle.MovementCommand;

public class MovementCommandImpl
implements MovementCommand {
    private final Route route;
    private final Route.Step step;
    private final String operation;
    private final Location opLocation;
    private final boolean finalMovement;
    private final Point finalDestination;
    private final Location finalDestinationLocation;
    private final String finalOperation;
    private final Map<String, String> properties;

    public MovementCommandImpl(Route route, Route.Step step, String operation, Location opLocation, boolean finalMovement, Location finalDestinationLocation, Point finalDestination, String finalOperation, Map<String, String> properties) {
        this.step = Objects.requireNonNull(step, "step");
        this.operation = Objects.requireNonNull(operation, "operation");
        this.finalMovement = finalMovement;
        this.finalDestinationLocation = finalDestinationLocation;
        this.finalDestination = Objects.requireNonNull(finalDestination, "finalDestination");
        this.finalOperation = Objects.requireNonNull(finalOperation, "finalOperation");
        this.properties = Objects.requireNonNull(properties, "properties");
        if (opLocation == null && !MovementCommandImpl.isEmptyOperation(operation)) {
            throw new NullPointerException("opLocation");
        }
        this.opLocation = opLocation;
        this.route = Objects.requireNonNull(route, "route");
    }

    public Route getRoute() {
        return this.route;
    }

    @Nonnull
    public Route.Step getStep() {
        return this.step;
    }

    @Nonnull
    public String getOperation() {
        return this.operation;
    }

    public boolean isWithoutOperation() {
        return MovementCommandImpl.isEmptyOperation(this.operation);
    }

    @Nullable
    public Location getOpLocation() {
        return this.opLocation;
    }

    public boolean isFinalMovement() {
        return this.finalMovement;
    }

    @Nonnull
    public Point getFinalDestination() {
        return this.finalDestination;
    }

    @Nullable
    public Location getFinalDestinationLocation() {
        return this.finalDestinationLocation;
    }

    @Nonnull
    public String getFinalOperation() {
        return this.finalOperation;
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o instanceof MovementCommand) {
            MovementCommand other = (MovementCommand)o;
            return this.step.equals((Object)other.getStep()) && this.operation.equals(other.getOperation());
        }
        return false;
    }

    public int hashCode() {
        return this.step.hashCode() ^ this.operation.hashCode();
    }

    public String toString() {
        return "MovementCommandImpl{route=" + this.getRoute() + ", step=" + this.getStep() + ", operation=" + this.getOperation() + ", opLocation=" + this.getOpLocation() + ", finalMovement=" + this.isFinalMovement() + ", finalDestination=" + this.getFinalDestination() + ", finalDestinationLocation=" + this.getFinalDestinationLocation() + ", finalOperation=" + this.getFinalOperation() + ", properties=" + this.getProperties() + "}";
    }

    private static boolean isEmptyOperation(String operation) {
        return "NOP".equals(operation) || "MOVE".equals(operation) || "PARK".equals(operation);
    }
}

