/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.LocalKernel;
import org.opentcs.access.ModelTransitionEvent;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.components.kernel.services.InternalPlantModelService;
import org.opentcs.components.kernel.services.NotificationService;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Block;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.LocationType;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.PlantModel;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.model.visualization.VisualLayout;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.kernel.persistence.ModelPersister;
import org.opentcs.kernel.services.AbstractTCSObjectService;
import org.opentcs.kernel.workingset.PlantModelManager;
import org.opentcs.util.event.EventHandler;

public class StandardPlantModelService
extends AbstractTCSObjectService
implements InternalPlantModelService {
    private final Kernel kernel;
    private final Object globalSyncObject;
    private final PlantModelManager plantModelManager;
    private final ModelPersister modelPersister;
    private final EventHandler eventHandler;
    private final NotificationService notificationService;

    @Inject
    public StandardPlantModelService(LocalKernel kernel, TCSObjectService objectService, @GlobalSyncObject Object globalSyncObject, PlantModelManager plantModelManager, ModelPersister modelPersister, @ApplicationEventBus EventHandler eventHandler, NotificationService notificationService) {
        super(objectService);
        this.kernel = (Kernel)Objects.requireNonNull(kernel, "kernel");
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.plantModelManager = Objects.requireNonNull(plantModelManager, "plantModelManager");
        this.modelPersister = Objects.requireNonNull(modelPersister, "modelPersister");
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
        this.notificationService = Objects.requireNonNull(notificationService, "notificationService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TCSResource<?>> expandResources(Set<TCSResourceReference<?>> resources) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.plantModelManager.expandResources(resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPlantModel() throws IllegalStateException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            if (!this.modelPersister.hasSavedModel()) {
                this.createPlantModel(new PlantModelCreationTO("unnamed"));
                return;
            }
            String oldModelName = this.getModelName();
            PlantModelCreationTO modelCreationTO = this.modelPersister.readModel();
            String newModelName = Strings.isNullOrEmpty((String)modelCreationTO.getName()) ? "" : modelCreationTO.getName();
            this.emitModelEvent(oldModelName, newModelName, true, false);
            this.plantModelManager.createPlantModelObjects(modelCreationTO);
            this.emitModelEvent(oldModelName, newModelName, true, true);
            this.notificationService.publishUserNotification(new UserNotification("Kernel loaded model " + newModelName, UserNotification.Level.INFORMATIONAL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePlantModel() throws IllegalStateException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.modelPersister.saveModel(this.plantModelManager.createPlantModelCreationTO());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlantModel getPlantModel() {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return new PlantModel(this.plantModelManager.getName()).withProperties(this.getModelProperties()).withPoints(this.fetchObjects(Point.class)).withPaths(this.fetchObjects(Path.class)).withLocationTypes(this.fetchObjects(LocationType.class)).withLocations(this.fetchObjects(Location.class)).withBlocks(this.fetchObjects(Block.class)).withVehicles(this.fetchObjects(Vehicle.class)).withVisuaLayouts(this.fetchObjects(VisualLayout.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPlantModel(PlantModelCreationTO to) throws ObjectUnknownException, ObjectExistsException, IllegalStateException {
        boolean kernelInOperating;
        boolean bl = kernelInOperating = this.kernel.getState() == Kernel.State.OPERATING;
        if (kernelInOperating) {
            this.kernel.setState(Kernel.State.MODELLING);
        }
        String oldModelName = this.getModelName();
        this.emitModelEvent(oldModelName, to.getName(), true, false);
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.plantModelManager.createPlantModelObjects(to);
        }
        this.savePlantModel();
        if (kernelInOperating) {
            this.kernel.setState(Kernel.State.OPERATING);
        }
        this.emitModelEvent(oldModelName, to.getName(), true, true);
        this.notificationService.publishUserNotification(new UserNotification("Kernel created model " + to.getName(), UserNotification.Level.INFORMATIONAL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelName() {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.plantModelManager.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getModelProperties() throws KernelRuntimeException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.plantModelManager.getProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocationLock(TCSObjectReference<Location> ref, boolean locked) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.plantModelManager.setLocationLocked(ref, locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void updateLocationReservationToken(TCSObjectReference<Location> ref, String token) throws ObjectUnknownException, KernelRuntimeException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.plantModelManager.setLocationReservationToken(ref, token);
        }
    }

    private void emitModelEvent(String oldModelName, String newModelName, boolean modelContentChanged, boolean transitionFinished) {
        Objects.requireNonNull(newModelName, "newModelName");
        this.eventHandler.onEvent((Object)new ModelTransitionEvent(oldModelName, newModelName, modelContentChanged, transitionFinished));
    }
}

