/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.to.peripherals.PeripheralJobCreationTO;
import org.opentcs.components.kernel.services.InternalPeripheralJobService;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.kernel.services.AbstractTCSObjectService;
import org.opentcs.kernel.workingset.PeripheralJobPoolManager;

public class StandardPeripheralJobService
extends AbstractTCSObjectService
implements InternalPeripheralJobService {
    private final Object globalSyncObject;
    private final PeripheralJobPoolManager jobPoolManager;

    @Inject
    public StandardPeripheralJobService(TCSObjectService objectService, @GlobalSyncObject Object globalSyncObject, PeripheralJobPoolManager jobPoolManager) {
        super(objectService);
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.jobPoolManager = Objects.requireNonNull(jobPoolManager, "jobPoolManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePeripheralJobState(TCSObjectReference<PeripheralJob> ref, PeripheralJob.State state) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.jobPoolManager.setPeripheralJobState(ref, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeripheralJob createPeripheralJob(PeripheralJobCreationTO to) throws ObjectUnknownException, ObjectExistsException, KernelRuntimeException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.jobPoolManager.createPeripheralJob(to);
        }
    }
}

