/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.components.kernel.PeripheralJobDispatcher;
import org.opentcs.components.kernel.services.PeripheralDispatcherService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.kernel.workingset.TCSObjectRepository;

public class StandardPeripheralDispatcherService
implements PeripheralDispatcherService {
    private final Object globalSyncObject;
    private final TCSObjectRepository objectRepo;
    private final PeripheralJobDispatcher dispatcher;

    @Inject
    public StandardPeripheralDispatcherService(@GlobalSyncObject Object globalSyncObject, TCSObjectRepository objectRepo, PeripheralJobDispatcher dispatcher) {
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.objectRepo = Objects.requireNonNull(objectRepo, "objectRepo");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.dispatcher.dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withdrawByLocation(TCSResourceReference<Location> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.dispatcher.withdrawJob(this.objectRepo.getObject(Location.class, ref));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withdrawByPeripheralJob(TCSObjectReference<PeripheralJob> ref) throws ObjectUnknownException, KernelRuntimeException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.dispatcher.withdrawJob(this.objectRepo.getObject(PeripheralJob.class, ref));
        }
    }
}

