/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.peripherals;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.drivers.peripherals.PeripheralCommAdapter;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterDescription;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterFactory;
import org.opentcs.drivers.peripherals.PeripheralProcessModel;
import org.opentcs.kernel.peripherals.NullPeripheralCommAdapterFactory;

public class PeripheralEntry {
    private final List<PeripheralCommAdapterDescription> availableCommAdapters;
    private PeripheralCommAdapterFactory commAdapterFactory = new NullPeripheralCommAdapterFactory();
    private PeripheralCommAdapter commAdapter;

    public PeripheralEntry(@Nonnull Location location, @Nonnull List<PeripheralCommAdapterDescription> availableCommAdapters) {
        Objects.requireNonNull(location, "location");
        this.availableCommAdapters = Objects.requireNonNull(availableCommAdapters, "availableCommAdapters");
        this.commAdapter = this.commAdapterFactory.getAdapterFor(location);
    }

    @Nonnull
    public PeripheralProcessModel getProcessModel() {
        return this.commAdapter.getProcessModel();
    }

    @Nonnull
    public TCSResourceReference<Location> getLocation() {
        return this.getProcessModel().getLocation();
    }

    @Nonnull
    public List<PeripheralCommAdapterDescription> getAvailableCommAdapters() {
        return this.availableCommAdapters;
    }

    @Nonnull
    public PeripheralCommAdapterFactory getCommAdapterFactory() {
        return this.commAdapterFactory;
    }

    public void setCommAdapterFactory(@Nonnull PeripheralCommAdapterFactory commAdapterFactory) {
        this.commAdapterFactory = Objects.requireNonNull(commAdapterFactory, "commAdapterFactory");
    }

    @Nonnull
    public PeripheralCommAdapter getCommAdapter() {
        return this.commAdapter;
    }

    public void setCommAdapter(@Nonnull PeripheralCommAdapter commAdapter) {
        this.commAdapter = Objects.requireNonNull(commAdapter, "commAdapter");
    }

    public String toString() {
        return "PeripheralEntry{availableCommAdapters=" + this.availableCommAdapters + ", commAdapterFactory=" + this.commAdapterFactory + ", commAdapter=" + this.commAdapter + "}";
    }
}

