/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.peripherals;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.drivers.peripherals.PeripheralCommAdapter;
import org.opentcs.drivers.peripherals.PeripheralController;
import org.opentcs.kernel.peripherals.DefaultPeripheralController;
import org.opentcs.kernel.peripherals.LocalPeripheralControllerPool;
import org.opentcs.kernel.peripherals.PeripheralControllerFactory;
import org.opentcs.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPeripheralControllerPool
implements LocalPeripheralControllerPool {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPeripheralControllerPool.class);
    private final TCSObjectService objectService;
    private final PeripheralControllerFactory controllerFactory;
    private final Map<TCSResourceReference<Location>, PoolEntry> poolEntries = new HashMap<TCSResourceReference<Location>, PoolEntry>();
    private boolean initialized;

    @Inject
    public DefaultPeripheralControllerPool(TCSObjectService objectService, PeripheralControllerFactory controllerFactory) {
        this.objectService = Objects.requireNonNull(objectService, "objectService");
        this.controllerFactory = Objects.requireNonNull(controllerFactory, "controllerFactory");
    }

    public void initialize() {
        if (this.isInitialized()) {
            LOG.debug("Already initialized, doing nothing.");
            return;
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            LOG.debug("Not initialized, doing nothing.");
            return;
        }
        for (PoolEntry curEntry : this.poolEntries.values()) {
            curEntry.controller.terminate();
        }
        this.poolEntries.clear();
        this.initialized = false;
    }

    public PeripheralController getPeripheralController(TCSResourceReference<Location> locationRef) throws IllegalArgumentException {
        Objects.requireNonNull(locationRef, "locationRef");
        Assertions.checkArgument((boolean)this.poolEntries.containsKey(locationRef), (String)"No controller present for %s", (Object[])new Object[]{locationRef.getName()});
        return this.poolEntries.get(locationRef).getController();
    }

    @Override
    public void attachPeripheralController(TCSResourceReference<Location> locationRef, PeripheralCommAdapter commAdapter) throws IllegalArgumentException {
        Objects.requireNonNull(locationRef, "locationRef");
        Objects.requireNonNull(commAdapter, "commAdapter");
        if (this.poolEntries.containsKey(locationRef)) {
            LOG.warn("{}: Peripheral controller already attached, doing nothing.", (Object)locationRef.getName());
            return;
        }
        Location location = (Location)this.objectService.fetchObject(Location.class, locationRef);
        Assertions.checkArgument((location != null ? 1 : 0) != 0, (String)"No such location: %s", (Object[])new Object[]{locationRef.getName()});
        LOG.debug("{}: Attaching controller...", (Object)locationRef.getName());
        DefaultPeripheralController controller = this.controllerFactory.createPeripheralController(locationRef, commAdapter);
        this.poolEntries.put(locationRef, new PoolEntry(locationRef, controller, commAdapter));
        controller.initialize();
    }

    @Override
    public void detachPeripheralController(TCSResourceReference<Location> locationRef) {
        Objects.requireNonNull(locationRef, "locationRef");
        if (!this.poolEntries.containsKey(locationRef)) {
            LOG.debug("{}: No peripheral controller attached, doing nothing.", (Object)locationRef.getName());
            return;
        }
        LOG.debug("{}: Detaching controller...", (Object)locationRef.getName());
        this.poolEntries.remove(locationRef).getController().terminate();
    }

    private static class PoolEntry {
        private final TCSResourceReference<Location> location;
        private final PeripheralController controller;
        private final PeripheralCommAdapter commAdapter;

        private PoolEntry(TCSResourceReference<Location> location, PeripheralController controller, PeripheralCommAdapter cmmmAdapter) {
            this.location = Objects.requireNonNull(location, "location");
            this.controller = Objects.requireNonNull(controller, "controller");
            this.commAdapter = Objects.requireNonNull(cmmmAdapter, "cmmmAdapter");
        }

        public TCSResourceReference<Location> getLocation() {
            return this.location;
        }

        public PeripheralController getController() {
            return this.controller;
        }

        public PeripheralCommAdapter getCommAdapter() {
            return this.commAdapter;
        }
    }
}

