/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.extensions.controlcenter.vehicles;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.components.Lifecycle;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.data.model.Vehicle;
import org.opentcs.kernel.extensions.controlcenter.vehicles.VehicleEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleEntryPool
implements Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleEntryPool.class);
    private final TCSObjectService objectService;
    private final Map<String, VehicleEntry> entries = new TreeMap<String, VehicleEntry>();
    private boolean initialized;

    @Inject
    public VehicleEntryPool(@Nonnull TCSObjectService objectService) {
        this.objectService = Objects.requireNonNull(objectService, "objectService");
    }

    public void initialize() {
        if (this.isInitialized()) {
            LOG.debug("Already initialized.");
            return;
        }
        this.objectService.fetchObjects(Vehicle.class).stream().forEach(vehicle -> this.entries.put(vehicle.getName(), new VehicleEntry((Vehicle)vehicle)));
        LOG.debug("Initialized vehicle entry pool: {}", this.entries);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            LOG.debug("Not initialized.");
            return;
        }
        this.entries.clear();
        this.initialized = false;
    }

    @Nonnull
    public Map<String, VehicleEntry> getEntries() {
        return this.entries;
    }

    @Nullable
    public VehicleEntry getEntryFor(@Nonnull String vehicleName) {
        Objects.requireNonNull(vehicleName, "vehicleName");
        return this.entries.get(vehicleName);
    }
}

