/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.extensions.controlcenter.vehicles;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.VehicleCommAdapter;
import org.opentcs.drivers.vehicle.VehicleCommAdapterFactory;
import org.opentcs.drivers.vehicle.VehicleProcessModel;
import org.opentcs.kernel.extensions.controlcenter.vehicles.NullVehicleCommAdapterFactory;

public class VehicleEntry
implements PropertyChangeListener {
    private final Vehicle vehicle;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private VehicleProcessModel processModel;
    private VehicleCommAdapterFactory commAdapterFactory = new NullVehicleCommAdapterFactory();
    private VehicleCommAdapter commAdapter;

    public VehicleEntry(Vehicle vehicle) {
        this.vehicle = Objects.requireNonNull(vehicle, "vehicle");
        this.processModel = new VehicleProcessModel(vehicle);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof VehicleProcessModel)) {
            return;
        }
        this.pcs.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Nonnull
    public Vehicle getVehicle() {
        return this.vehicle;
    }

    @Nonnull
    public String getVehicleName() {
        return this.vehicle.getName();
    }

    @Nonnull
    public VehicleProcessModel getProcessModel() {
        return this.processModel;
    }

    public void setProcessModel(@Nonnull VehicleProcessModel processModel) {
        VehicleProcessModel oldProcessModel = this.processModel;
        this.processModel = Objects.requireNonNull(processModel, "processModel");
        oldProcessModel.removePropertyChangeListener((PropertyChangeListener)this);
        processModel.addPropertyChangeListener((PropertyChangeListener)this);
        this.pcs.firePropertyChange(Attribute.PROCESS_MODEL.name(), oldProcessModel, processModel);
    }

    @Nonnull
    public VehicleCommAdapterFactory getCommAdapterFactory() {
        return this.commAdapterFactory;
    }

    public void setCommAdapterFactory(@Nonnull VehicleCommAdapterFactory commAdapterFactory) {
        VehicleCommAdapterFactory oldValue = this.commAdapterFactory;
        this.commAdapterFactory = commAdapterFactory;
        this.pcs.firePropertyChange(Attribute.COMM_ADAPTER_FACTORY.name(), oldValue, commAdapterFactory);
    }

    @Nullable
    public VehicleCommAdapter getCommAdapter() {
        return this.commAdapter;
    }

    public void setCommAdapter(@Nullable VehicleCommAdapter commAdapter) {
        VehicleCommAdapter oldValue = this.commAdapter;
        this.commAdapter = commAdapter;
        this.pcs.firePropertyChange(Attribute.COMM_ADAPTER.name(), oldValue, commAdapter);
    }

    public static enum Attribute {
        PROCESS_MODEL,
        COMM_ADAPTER_FACTORY,
        COMM_ADAPTER;

    }
}

