/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import org.opentcs.configuration.ConfigurationBindingProvider;
import org.opentcs.configuration.cfg4j.Cfg4jConfigurationBindingProvider;
import org.opentcs.customizations.kernel.KernelInjectionModule;
import org.opentcs.kernel.DefaultKernelInjectionModule;
import org.opentcs.kernel.KernelStarter;
import org.opentcs.strategies.basic.dispatching.DefaultDispatcherModule;
import org.opentcs.strategies.basic.peripherals.dispatching.DefaultPeripheralJobDispatcherModule;
import org.opentcs.strategies.basic.routing.DefaultRouterModule;
import org.opentcs.strategies.basic.scheduling.DefaultSchedulerModule;
import org.opentcs.util.Environment;
import org.opentcs.util.logging.UncaughtExceptionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunKernel {
    private static final Logger LOG = LoggerFactory.getLogger(RunKernel.class);

    private RunKernel() {
    }

    public static void main(String[] args) throws Exception {
        System.setSecurityManager(new SecurityManager());
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionLogger(false));
        Environment.logSystemInfo();
        LOG.debug("Setting up openTCS kernel {}...", (Object)Environment.getBaselineVersion());
        Injector injector = Guice.createInjector((Module[])new Module[]{RunKernel.customConfigurationModule()});
        ((KernelStarter)injector.getInstance(KernelStarter.class)).startKernel();
    }

    private static Module customConfigurationModule() {
        List<KernelInjectionModule> defaultModules = Arrays.asList(new KernelInjectionModule[]{new DefaultKernelInjectionModule(), new DefaultDispatcherModule(), new DefaultRouterModule(), new DefaultSchedulerModule(), new DefaultPeripheralJobDispatcherModule()});
        ConfigurationBindingProvider bindingProvider = RunKernel.configurationBindingProvider();
        for (KernelInjectionModule defaultModule : defaultModules) {
            defaultModule.setConfigBindingProvider(bindingProvider);
        }
        return Modules.override(defaultModules).with(RunKernel.findRegisteredModules(bindingProvider));
    }

    private static List<KernelInjectionModule> findRegisteredModules(ConfigurationBindingProvider bindingProvider) {
        ArrayList<KernelInjectionModule> registeredModules = new ArrayList<KernelInjectionModule>();
        for (KernelInjectionModule module : ServiceLoader.load(KernelInjectionModule.class)) {
            LOG.info("Integrating injection module {} (source: {})", (Object)module.getClass().getName(), (Object)module.getClass().getProtectionDomain().getCodeSource());
            module.setConfigBindingProvider(bindingProvider);
            registeredModules.add(module);
        }
        return registeredModules;
    }

    private static ConfigurationBindingProvider configurationBindingProvider() {
        return new Cfg4jConfigurationBindingProvider(Paths.get(System.getProperty("opentcs.base", "."), "config", "opentcs-kernel-defaults-baseline.properties").toAbsolutePath(), new Path[]{Paths.get(System.getProperty("opentcs.base", "."), "config", "opentcs-kernel-defaults-custom.properties").toAbsolutePath(), Paths.get(System.getProperty("opentcs.home", "."), "config", "opentcs-kernel.properties").toAbsolutePath()});
    }
}

