/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel;

import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.components.kernel.KernelExtension;
import org.opentcs.customizations.kernel.ActiveInModellingMode;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.kernel.KernelApplicationConfiguration;
import org.opentcs.kernel.KernelStateOnline;
import org.opentcs.kernel.persistence.ModelPersister;
import org.opentcs.kernel.workingset.PlantModelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelStateModelling
extends KernelStateOnline {
    private static final Logger LOG = LoggerFactory.getLogger(KernelStateModelling.class);
    private final Set<KernelExtension> extensions;
    private boolean initialized;

    @Inject
    public KernelStateModelling(@GlobalSyncObject Object globalSyncObject, PlantModelManager plantModelManager, ModelPersister modelPersister, KernelApplicationConfiguration configuration, @ActiveInModellingMode Set<KernelExtension> extensions) {
        super(globalSyncObject, plantModelManager, modelPersister, configuration.saveModelOnTerminateModelling());
        this.extensions = Objects.requireNonNull(extensions, "extensions");
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        LOG.debug("Initializing modelling state...");
        for (KernelExtension extension : this.extensions) {
            LOG.debug("Initializing kernel extension '{}'...", (Object)extension);
            extension.initialize();
        }
        LOG.debug("Finished initializing kernel extensions.");
        this.initialized = true;
        LOG.debug("Modelling state initialized.");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void terminate() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized, cannot terminate");
        }
        LOG.debug("Terminating modelling state...");
        super.terminate();
        for (KernelExtension extension : this.extensions) {
            LOG.debug("Terminating kernel extension '{}'...", (Object)extension);
            extension.terminate();
        }
        LOG.debug("Terminated kernel extensions.");
        this.initialized = false;
        LOG.debug("Modelling state terminated.");
    }

    @Override
    public Kernel.State getState() {
        return Kernel.State.MODELLING;
    }
}

