/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.workingset;

import java.time.Instant;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.access.to.order.DestinationCreationTO;
import org.opentcs.access.to.order.OrderSequenceCreationTO;
import org.opentcs.access.to.order.TransportOrderCreationTO;
import org.opentcs.components.kernel.ObjectNameProvider;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.kernel.workingset.TCSObjectPool;
import org.opentcs.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportOrderPool {
    private static final Logger LOG = LoggerFactory.getLogger(TransportOrderPool.class);
    private final TCSObjectPool objectPool;
    private final ObjectNameProvider objectNameProvider;

    @Inject
    public TransportOrderPool(TCSObjectPool objectPool, ObjectNameProvider orderNameProvider) {
        this.objectPool = Objects.requireNonNull(objectPool, "objectPool");
        this.objectNameProvider = Objects.requireNonNull(orderNameProvider, "orderNameProvider");
    }

    public TCSObjectPool getObjectPool() {
        LOG.debug("method entry");
        return this.objectPool;
    }

    public void clear() {
        LOG.debug("method entry");
        for (TCSObject<?> curObject : this.objectPool.getObjects((Pattern)null)) {
            if (!(curObject instanceof TransportOrder) && !(curObject instanceof OrderSequence)) continue;
            this.objectPool.removeObject(curObject.getReference());
            this.objectPool.emitObjectEvent(null, curObject, TCSObjectEvent.Type.OBJECT_REMOVED);
        }
    }

    public TransportOrder createTransportOrder(TransportOrderCreationTO to) throws ObjectUnknownException, ObjectExistsException, IllegalArgumentException {
        TransportOrder newOrder = new TransportOrder(this.nameFor(to), this.toDriveOrders(to.getDestinations())).withCreationTime(Instant.now()).withPeripheralReservationToken(to.getPeripheralReservationToken()).withIntendedVehicle(this.toVehicleReference(to.getIntendedVehicleName())).withType(to.getType()).withDeadline(to.getDeadline()).withDispensable(to.isDispensable()).withWrappingSequence(this.getWrappingSequence(to)).withDependencies(this.getDependencies(to)).withProperties(to.getProperties());
        this.objectPool.addObject((TCSObject<?>)newOrder);
        this.objectPool.emitObjectEvent((TCSObject<?>)newOrder, null, TCSObjectEvent.Type.OBJECT_CREATED);
        if (newOrder.getWrappingSequence() != null) {
            OrderSequence sequence;
            OrderSequence prevSeq = sequence = this.objectPool.getObject(OrderSequence.class, newOrder.getWrappingSequence());
            sequence = this.objectPool.replaceObject(sequence.withOrder(newOrder.getReference()));
            this.objectPool.emitObjectEvent((TCSObject<?>)sequence, (TCSObject<?>)prevSeq, TCSObjectEvent.Type.OBJECT_MODIFIED);
        }
        return newOrder;
    }

    public TransportOrder setTransportOrderState(TCSObjectReference<TransportOrder> ref, TransportOrder.State newState) throws ObjectUnknownException {
        TransportOrder order;
        LOG.debug("method entry");
        TransportOrder previousState = order = this.objectPool.getObject(TransportOrder.class, ref);
        order = this.objectPool.replaceObject(order.withState(newState));
        this.objectPool.emitObjectEvent((TCSObject<?>)order, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return order;
    }

    public TransportOrder setTransportOrderProcessingVehicle(TCSObjectReference<TransportOrder> orderRef, TCSObjectReference<Vehicle> vehicleRef, List<DriveOrder> driveOrders) throws ObjectUnknownException, IllegalArgumentException {
        TransportOrder order;
        TransportOrder previousState = order = this.objectPool.getObject(TransportOrder.class, orderRef);
        if (vehicleRef == null) {
            order = this.objectPool.replaceObject(order.withProcessingVehicle(null));
        } else {
            Vehicle vehicle = this.objectPool.getObject(Vehicle.class, vehicleRef);
            if ((order = this.objectPool.replaceObject(order.withProcessingVehicle(vehicle.getReference()).withDriveOrders(driveOrders).withCurrentDriveOrderIndex(0))).getCurrentDriveOrder() != null) {
                order = this.objectPool.replaceObject(order.withCurrentDriveOrderState(DriveOrder.State.TRAVELLING));
            }
        }
        this.objectPool.emitObjectEvent((TCSObject<?>)order, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return order;
    }

    public TransportOrder setTransportOrderDriveOrders(TCSObjectReference<TransportOrder> orderRef, List<DriveOrder> newOrders) throws ObjectUnknownException, IllegalArgumentException {
        TransportOrder order;
        LOG.debug("method entry");
        TransportOrder previousState = order = this.objectPool.getObject(TransportOrder.class, orderRef);
        order = this.objectPool.replaceObject(order.withDriveOrders(newOrders));
        this.objectPool.emitObjectEvent((TCSObject<?>)order, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return order;
    }

    public TransportOrder setTransportOrderNextDriveOrder(TCSObjectReference<TransportOrder> ref) throws ObjectUnknownException {
        TransportOrder order;
        LOG.debug("method entry");
        TransportOrder previousState = order = this.objectPool.getObject(TransportOrder.class, ref);
        if (order.getCurrentDriveOrder() != null) {
            TransportOrder newState = order = this.objectPool.replaceObject(order.withCurrentDriveOrderState(DriveOrder.State.FINISHED));
            this.objectPool.emitObjectEvent((TCSObject<?>)newState, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
            previousState = newState;
            newState = order = this.objectPool.replaceObject(order.withCurrentDriveOrderIndex(order.getCurrentDriveOrderIndex() + 1));
            this.objectPool.emitObjectEvent((TCSObject<?>)newState, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
            previousState = newState;
            if (order.getCurrentDriveOrder() != null) {
                newState = order = this.objectPool.replaceObject(order.withCurrentDriveOrderState(DriveOrder.State.TRAVELLING));
                this.objectPool.emitObjectEvent((TCSObject<?>)newState, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
                previousState = newState;
            }
        }
        this.objectPool.emitObjectEvent((TCSObject<?>)order, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return order;
    }

    public TransportOrder removeTransportOrder(TCSObjectReference<TransportOrder> ref) throws ObjectUnknownException {
        LOG.debug("method entry");
        TransportOrder order = this.objectPool.getObject(TransportOrder.class, ref);
        Assertions.checkArgument((!order.hasState(TransportOrder.State.BEING_PROCESSED) ? 1 : 0) != 0, (String)"Transport order %s is being processed.", (Object[])new Object[]{order.getName()});
        this.objectPool.removeObject(ref);
        this.objectPool.emitObjectEvent(null, (TCSObject<?>)order, TCSObjectEvent.Type.OBJECT_REMOVED);
        return order;
    }

    public OrderSequence createOrderSequence(OrderSequenceCreationTO to) throws ObjectExistsException, ObjectUnknownException {
        OrderSequence newSequence = new OrderSequence(this.nameFor(to)).withType(to.getType()).withIntendedVehicle(this.toVehicleReference(to.getIntendedVehicleName())).withFailureFatal(to.isFailureFatal()).withProperties(to.getProperties());
        this.objectPool.addObject((TCSObject<?>)newSequence);
        this.objectPool.emitObjectEvent((TCSObject<?>)newSequence, null, TCSObjectEvent.Type.OBJECT_CREATED);
        return newSequence;
    }

    public OrderSequence setOrderSequenceFinishedIndex(TCSObjectReference<OrderSequence> seqRef, int index) throws ObjectUnknownException {
        OrderSequence sequence;
        LOG.debug("method entry");
        OrderSequence previousState = sequence = this.objectPool.getObject(OrderSequence.class, seqRef);
        sequence = this.objectPool.replaceObject(sequence.withFinishedIndex(index));
        this.objectPool.emitObjectEvent((TCSObject<?>)sequence, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return sequence;
    }

    public OrderSequence setOrderSequenceComplete(TCSObjectReference<OrderSequence> seqRef) throws ObjectUnknownException {
        OrderSequence sequence;
        LOG.debug("method entry");
        OrderSequence previousState = sequence = this.objectPool.getObject(OrderSequence.class, seqRef);
        sequence = this.objectPool.replaceObject(sequence.withComplete(true));
        this.objectPool.emitObjectEvent((TCSObject<?>)sequence, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return sequence;
    }

    public OrderSequence setOrderSequenceFinished(TCSObjectReference<OrderSequence> seqRef) throws ObjectUnknownException {
        OrderSequence sequence;
        LOG.debug("method entry");
        OrderSequence previousState = sequence = this.objectPool.getObject(OrderSequence.class, seqRef);
        sequence = this.objectPool.replaceObject(sequence.withFinished(true));
        this.objectPool.emitObjectEvent((TCSObject<?>)sequence, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return sequence;
    }

    public OrderSequence setOrderSequenceProcessingVehicle(TCSObjectReference<OrderSequence> seqRef, TCSObjectReference<Vehicle> vehicleRef) throws ObjectUnknownException {
        OrderSequence sequence;
        LOG.debug("method entry");
        OrderSequence previousState = sequence = this.objectPool.getObject(OrderSequence.class, seqRef);
        if (vehicleRef == null) {
            sequence = this.objectPool.replaceObject(sequence.withProcessingVehicle(null));
        } else {
            Vehicle vehicle = this.objectPool.getObject(Vehicle.class, vehicleRef);
            sequence = this.objectPool.replaceObject(sequence.withProcessingVehicle(vehicle.getReference()));
        }
        this.objectPool.emitObjectEvent((TCSObject<?>)sequence, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return sequence;
    }

    public OrderSequence removeOrderSequence(TCSObjectReference<OrderSequence> ref) throws ObjectUnknownException {
        OrderSequence sequence;
        LOG.debug("method entry");
        OrderSequence previousState = sequence = this.objectPool.getObject(OrderSequence.class, ref);
        this.objectPool.removeObject(ref);
        this.objectPool.emitObjectEvent(null, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_REMOVED);
        return sequence;
    }

    public void removeFinishedOrderSequenceAndOrders(TCSObjectReference<OrderSequence> ref) throws ObjectUnknownException, IllegalArgumentException {
        OrderSequence sequence = this.objectPool.getObject(OrderSequence.class, ref);
        Assertions.checkArgument((boolean)sequence.isFinished(), (String)"Order sequence %s is not finished", (Object[])new Object[]{sequence.getName()});
        OrderSequence previousState = sequence;
        this.objectPool.removeObject(ref);
        this.objectPool.emitObjectEvent(null, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_REMOVED);
        for (TCSObjectReference orderRef : sequence.getOrders()) {
            this.removeTransportOrder((TCSObjectReference<TransportOrder>)orderRef);
        }
    }

    private Set<TCSObjectReference<TransportOrder>> getDependencies(TransportOrderCreationTO to) throws ObjectUnknownException {
        HashSet<TCSObjectReference<TransportOrder>> result = new HashSet<TCSObjectReference<TransportOrder>>();
        for (String dependencyName : to.getDependencyNames()) {
            TransportOrder dep = this.getObjectPool().getObject(TransportOrder.class, dependencyName);
            if (dep == null) {
                throw new ObjectUnknownException(dependencyName);
            }
            result.add((TCSObjectReference<TransportOrder>)dep.getReference());
        }
        return result;
    }

    private TCSObjectReference<OrderSequence> getWrappingSequence(TransportOrderCreationTO to) throws ObjectUnknownException, IllegalArgumentException {
        if (to.getWrappingSequence() == null) {
            return null;
        }
        OrderSequence sequence = this.getObjectPool().getObject(OrderSequence.class, to.getWrappingSequence());
        if (sequence == null) {
            throw new ObjectUnknownException(to.getWrappingSequence());
        }
        Assertions.checkArgument((!sequence.isComplete() ? 1 : 0) != 0, (String)"Order sequence %s is already complete", (Object[])new Object[]{sequence});
        Assertions.checkArgument((boolean)Objects.equals(to.getType(), sequence.getType()), (String)"Order sequence %s has different type than order %s: %s != %s", (Object[])new Object[]{sequence, to.getName(), sequence.getType(), to.getType()});
        Assertions.checkArgument((boolean)Objects.equals(to.getIntendedVehicleName(), this.getIntendedVehicleName(sequence)), (String)"Order sequence %s has different intended vehicle than order %s: %s != %s", (Object[])new Object[]{sequence, to.getName(), sequence.getIntendedVehicle(), to.getIntendedVehicleName()});
        return sequence.getReference();
    }

    private TCSObjectReference<Vehicle> toVehicleReference(String vehicleName) throws ObjectUnknownException {
        if (vehicleName == null) {
            return null;
        }
        Vehicle vehicle = this.objectPool.getObject(Vehicle.class, vehicleName);
        return vehicle.getReference();
    }

    private List<DriveOrder> toDriveOrders(List<DestinationCreationTO> dests) throws ObjectUnknownException {
        LinkedList<DriveOrder> result = new LinkedList<DriveOrder>();
        for (DestinationCreationTO destTo : dests) {
            TCSObject<?> destObject = this.objectPool.getObjectOrNull(destTo.getDestLocationName());
            if (!(destObject instanceof Location) && !(destObject instanceof Point)) {
                throw new ObjectUnknownException(destTo.getDestLocationName());
            }
            result.add(new DriveOrder(new DriveOrder.Destination(destObject.getReference()).withOperation(destTo.getDestOperation()).withProperties(destTo.getProperties())));
        }
        return result;
    }

    @Nullable
    private String getIntendedVehicleName(OrderSequence sequence) {
        return sequence.getIntendedVehicle() == null ? null : sequence.getIntendedVehicle().getName();
    }

    @Nonnull
    private String nameFor(@Nonnull TransportOrderCreationTO to) {
        if (to.hasIncompleteName()) {
            return (String)this.objectNameProvider.apply((Object)to);
        }
        return to.getName();
    }

    @Nonnull
    private String nameFor(@Nonnull OrderSequenceCreationTO to) {
        if (to.hasIncompleteName()) {
            return (String)this.objectNameProvider.apply((Object)to);
        }
        return to.getName();
    }
}

