/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.workingset;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentcs.access.to.peripherals.PeripheralJobCreationTO;
import org.opentcs.access.to.peripherals.PeripheralOperationCreationTO;
import org.opentcs.components.kernel.ObjectNameProvider;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.data.peripherals.PeripheralOperation;
import org.opentcs.kernel.workingset.TCSObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralJobPool {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralJobPool.class);
    private final TCSObjectPool objectPool;
    private final ObjectNameProvider objectNameProvider;

    @Inject
    public PeripheralJobPool(TCSObjectPool objectPool, ObjectNameProvider orderNameProvider) {
        this.objectPool = Objects.requireNonNull(objectPool, "objectPool");
        this.objectNameProvider = Objects.requireNonNull(orderNameProvider, "orderNameProvider");
    }

    public void clear() {
        for (PeripheralJob job : this.objectPool.getObjects(PeripheralJob.class)) {
            this.objectPool.removeObject(job.getReference());
            this.objectPool.emitObjectEvent(null, (TCSObject<?>)job, TCSObjectEvent.Type.OBJECT_REMOVED);
        }
    }

    public PeripheralJob createPeripheralJob(PeripheralJobCreationTO to) throws ObjectUnknownException, ObjectExistsException {
        PeripheralJob job = new PeripheralJob(this.nameFor(to), to.getReservationToken(), this.toPeripheralOperation(to.getPeripheralOperation())).withRelatedVehicle(this.toVehicleReference(to.getRelatedVehicleName())).withRelatedTransportOrder(this.toTransportOrderReference(to.getRelatedTransportOrderName())).withProperties(to.getProperties());
        this.objectPool.addObject((TCSObject<?>)job);
        this.objectPool.emitObjectEvent((TCSObject<?>)job, null, TCSObjectEvent.Type.OBJECT_CREATED);
        LOG.debug("Created peripheral job {}...", (Object)job.getName());
        return job;
    }

    public PeripheralJob setPeripheralJobState(TCSObjectReference<PeripheralJob> ref, PeripheralJob.State newState) throws ObjectUnknownException {
        PeripheralJob job;
        LOG.debug("Updating state of peripheral job {} to {}...", (Object)ref.getName(), (Object)newState);
        PeripheralJob previousState = job = this.objectPool.getObject(PeripheralJob.class, ref);
        job = this.objectPool.replaceObject(job.withState(newState));
        this.objectPool.emitObjectEvent((TCSObject<?>)job, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return job;
    }

    private PeripheralOperation toPeripheralOperation(PeripheralOperationCreationTO to) throws ObjectUnknownException {
        return new PeripheralOperation(this.toLocationReference(to.getLocationName()), to.getOperation(), to.getExecutionTrigger(), to.isCompletionRequired());
    }

    private TCSResourceReference<Location> toLocationReference(String locationName) throws ObjectUnknownException {
        Location location = this.objectPool.getObject(Location.class, locationName);
        return location.getReference();
    }

    private TCSObjectReference<Vehicle> toVehicleReference(String vehicleName) throws ObjectUnknownException {
        if (vehicleName == null) {
            return null;
        }
        Vehicle vehicle = this.objectPool.getObject(Vehicle.class, vehicleName);
        return vehicle.getReference();
    }

    private TCSObjectReference<TransportOrder> toTransportOrderReference(String transportOrderName) throws ObjectUnknownException {
        if (transportOrderName == null) {
            return null;
        }
        TransportOrder order = this.objectPool.getObject(TransportOrder.class, transportOrderName);
        return order.getReference();
    }

    @Nonnull
    private String nameFor(@Nonnull PeripheralJobCreationTO to) {
        if (to.hasIncompleteName()) {
            return (String)this.objectNameProvider.apply((Object)to);
        }
        return to.getName();
    }
}

