/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.workingset;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.opentcs.access.NotificationPublicationEvent;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationBuffer.class);
    private final List<UserNotification> notifications = new LinkedList<UserNotification>();
    private int capacity = 500;
    private int cutBackCount;
    private final EventHandler messageEventListener;

    @Inject
    public NotificationBuffer(@ApplicationEventBus EventHandler eventListener) {
        this.messageEventListener = Objects.requireNonNull(eventListener, "eventListener");
        this.cutBackCount = this.capacity;
    }

    public int getCapacity() {
        LOG.debug("method entry");
        return this.capacity;
    }

    public void setCapacity(int newCapacity) {
        LOG.debug("method entry");
        if (newCapacity < 1) {
            throw new IllegalArgumentException("newCapacity must be at least 1");
        }
        this.capacity = newCapacity;
        if (this.cutBackCount > this.capacity) {
            this.cutBackCount = this.capacity;
        }
        this.cutBackMessages();
    }

    public int getCutBackCount() {
        LOG.debug("method entry");
        return this.cutBackCount;
    }

    public void setCutBackCount(int newValue) {
        LOG.debug("method entry");
        if (newValue < 0 || newValue > this.capacity) {
            throw new IllegalArgumentException("newValue must be greater than 0 and less than or equal to capacity");
        }
        this.cutBackCount = newValue;
    }

    public int getMessageCount() {
        LOG.debug("method entry");
        return this.notifications.size();
    }

    public void addNotification(UserNotification notification) {
        Objects.requireNonNull(notification, "notification");
        this.notifications.add(notification);
        LOG.debug("New notification added: {}", (Object)notification.getText());
        this.cutBackMessages();
        this.emitMessageEvent(notification);
    }

    public List<UserNotification> getNotifications() {
        LOG.debug("method entry");
        return new LinkedList<UserNotification>(this.notifications);
    }

    public List<UserNotification> getNotifications(Predicate<UserNotification> predicate) {
        LOG.debug("method entry");
        LinkedList<UserNotification> result = new LinkedList<UserNotification>();
        for (UserNotification notification : this.notifications) {
            if (predicate != null && !predicate.test(notification)) continue;
            result.add(notification);
        }
        return result;
    }

    public void clear() {
        LOG.debug("method entry");
        this.notifications.clear();
    }

    private void cutBackMessages() {
        LOG.debug("method entry");
        if (this.notifications.size() > this.capacity) {
            while (this.notifications.size() > this.cutBackCount) {
                this.notifications.remove(this.notifications.size() - 1);
            }
        }
    }

    public void emitMessageEvent(UserNotification message) {
        this.messageEventListener.onEvent((Object)new NotificationPublicationEvent(message));
    }
}

