/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.vehicles;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opentcs.access.to.peripherals.PeripheralJobCreationTO;
import org.opentcs.access.to.peripherals.PeripheralOperationCreationTO;
import org.opentcs.components.kernel.services.PeripheralJobService;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.data.peripherals.PeripheralOperation;
import org.opentcs.drivers.vehicle.MovementCommand;
import org.opentcs.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralInteraction {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralInteraction.class);
    private final TCSObjectReference<Vehicle> vehicleRef;
    private final MovementCommand movementCommand;
    private final List<PeripheralOperation> operations;
    private final List<PeripheralJob> requiredJobs = new ArrayList<PeripheralJob>();
    private final PeripheralJobService peripheralJobService;
    private final String reservationToken;
    private Runnable interactionSucceededCallback;
    private Runnable interactionFailedCallback;
    private State state = State.PRISTINE;

    public PeripheralInteraction(@Nonnull TCSObjectReference<Vehicle> vehicleRef, @Nonnull MovementCommand movementCommand, @Nonnull List<PeripheralOperation> operations, @Nonnull PeripheralJobService peripheralJobService, @Nonnull String reservationToken) {
        this.vehicleRef = Objects.requireNonNull(vehicleRef, "vehicleRef");
        this.movementCommand = Objects.requireNonNull(movementCommand, "movementCommand");
        this.operations = Objects.requireNonNull(operations, "operations");
        this.peripheralJobService = Objects.requireNonNull(peripheralJobService, "peripheralJobService");
        this.reservationToken = Objects.requireNonNull(reservationToken, "reservationToken");
    }

    public void start(@Nonnull Runnable interactionSucceededCallback, @Nonnull Runnable interactionFailedCallback) {
        this.interactionSucceededCallback = Objects.requireNonNull(interactionSucceededCallback, "interactionSucceededCallback");
        this.interactionFailedCallback = Objects.requireNonNull(interactionFailedCallback, "interactionFailedCallback");
        LOG.debug("{}: Starting peripheral interaction for movement to {}", (Object)this.vehicleRef.getName(), (Object)this.movementCommand.getStep().getDestinationPoint().getName());
        for (PeripheralOperation operation : this.operations) {
            PeripheralJob job = this.createPeripheralJob(operation);
            if (!operation.isCompletionRequired()) continue;
            this.requiredJobs.add(job);
        }
        this.state = State.STARTED;
        if (this.requiredJobs.isEmpty()) {
            this.onInteractionFinished();
        }
    }

    public void onPeripheralJobFinished(@Nonnull PeripheralJob job) {
        Objects.requireNonNull(job, "job");
        if (this.requiredJobs.remove(job) && this.requiredJobs.isEmpty()) {
            this.onInteractionFinished();
        }
    }

    public void onPeripheralJobFailed(@Nonnull PeripheralJob job) {
        Objects.requireNonNull(job, "job");
        if (this.requiredJobs.contains(job)) {
            this.onInteractionFailed();
        }
    }

    public MovementCommand getMovementCommand() {
        return this.movementCommand;
    }

    public boolean isFinished() {
        return this.hasState(State.FINSHED);
    }

    public boolean isFailed() {
        return this.hasState(State.FAILED);
    }

    public boolean hasState(State state) {
        return this.state == state;
    }

    public boolean hasRequiredOperations() {
        return this.operations.stream().anyMatch(PeripheralOperation::isCompletionRequired);
    }

    public List<PeripheralOperation> getPendingRequiredOperations() {
        if (this.hasState(State.FINSHED)) {
            return new ArrayList<PeripheralOperation>();
        }
        if (!this.hasRequiredOperations()) {
            return new ArrayList<PeripheralOperation>();
        }
        if (!this.requiredJobs.isEmpty()) {
            return this.requiredJobs.stream().map(job -> job.getPeripheralOperation()).collect(Collectors.toList());
        }
        return this.operations.stream().filter(PeripheralOperation::isCompletionRequired).collect(Collectors.toList());
    }

    private void onInteractionFinished() {
        Assertions.checkState((this.interactionSucceededCallback != null ? 1 : 0) != 0, (String)"The interaction hasn't been started yet.");
        Assertions.checkState((!this.hasState(State.FAILED) ? 1 : 0) != 0, (String)"The interaction has already been marked as failed.");
        Assertions.checkState((!this.hasState(State.FINSHED) ? 1 : 0) != 0, (String)"The interaction has already been marked as finished.");
        this.state = State.FINSHED;
        LOG.debug("{}: Peripheral interaction finished for movement to {}", (Object)this.vehicleRef.getName(), (Object)this.movementCommand.getStep().getDestinationPoint().getName());
        this.interactionSucceededCallback.run();
    }

    private PeripheralJob createPeripheralJob(PeripheralOperation operation) {
        return this.peripheralJobService.createPeripheralJob(new PeripheralJobCreationTO("Job-", this.reservationToken, new PeripheralOperationCreationTO(operation.getOperation(), operation.getLocation().getName())).withIncompleteName(true));
    }

    private void onInteractionFailed() {
        Assertions.checkState((this.interactionFailedCallback != null ? 1 : 0) != 0, (String)"The interaction hasn't been started yet.");
        Assertions.checkState((!this.hasState(State.FINSHED) ? 1 : 0) != 0, (String)"The interaction has already been marked as finished.");
        Assertions.checkState((!this.hasState(State.FAILED) ? 1 : 0) != 0, (String)"The interaction has already been marked as failed.");
        this.state = State.FAILED;
        LOG.debug("{}: Peripheral interaction failed for movement to {}", (Object)this.vehicleRef.getName(), (Object)this.movementCommand.getStep().getDestinationPoint().getName());
        this.interactionFailedCallback.run();
    }

    public static enum State {
        PRISTINE,
        STARTED,
        FINSHED,
        FAILED;

    }
}

