/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.vehicles;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.MovementCommand;
import org.opentcs.drivers.vehicle.VehicleController;
import org.opentcs.util.ExplainedBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullVehicleController
implements VehicleController {
    private static final Logger LOG = LoggerFactory.getLogger(NullVehicleController.class);
    private final String vehicleName;

    public NullVehicleController(@Nonnull String vehicleName) {
        this.vehicleName = Objects.requireNonNull(vehicleName, "vehicleName");
    }

    public void initialize() {
    }

    public boolean isInitialized() {
        return true;
    }

    public void terminate() {
    }

    public void setTransportOrder(TransportOrder newOrder) {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
    }

    @Deprecated
    public void setDriveOrder(DriveOrder newOrder, Map<String, String> orderProperties) {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
    }

    @Deprecated
    public void updateDriveOrder(DriveOrder newOrder, Map<String, String> orderProperties) {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
    }

    public void abortTransportOrder(boolean immediate) {
        if (immediate) {
            this.clearDriveOrder();
        } else {
            this.abortDriveOrder();
        }
    }

    @Deprecated
    public void clearDriveOrder() {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
    }

    @Deprecated
    public void abortDriveOrder() {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
    }

    @Deprecated
    public void clearCommandQueue() {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
    }

    public ExplainedBoolean canProcess(TransportOrder order) {
        return new ExplainedBoolean(false, "NullVehicleController");
    }

    @Deprecated
    public ExplainedBoolean canProcess(List<String> operations) {
        return new ExplainedBoolean(false, "NullVehicleController");
    }

    public void sendCommAdapterMessage(Object message) {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
    }

    public void sendCommAdapterCommand(AdapterCommand command) {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
    }

    public String getId() {
        return this.vehicleName;
    }

    public boolean allocationSuccessful(Set<TCSResource<?>> resources) {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
        return false;
    }

    public void allocationFailed(Set<TCSResource<?>> resources) {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
    }

    public Queue<MovementCommand> getCommandsSent() {
        LOG.warn("No comm adapter attached to vehicle {}", (Object)this.vehicleName);
        return new LinkedList<MovementCommand>();
    }
}

