/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.components.kernel.services.InternalPeripheralService;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.PeripheralInformation;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.drivers.peripherals.PeripheralAdapterCommand;
import org.opentcs.drivers.peripherals.PeripheralCommAdapter;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterDescription;
import org.opentcs.drivers.peripherals.PeripheralProcessModel;
import org.opentcs.drivers.peripherals.management.PeripheralAttachmentInformation;
import org.opentcs.kernel.peripherals.PeripheralAttachmentManager;
import org.opentcs.kernel.peripherals.PeripheralEntry;
import org.opentcs.kernel.peripherals.PeripheralEntryPool;
import org.opentcs.kernel.services.AbstractTCSObjectService;
import org.opentcs.kernel.workingset.Model;

public class StandardPeripheralService
extends AbstractTCSObjectService
implements InternalPeripheralService {
    private final Object globalSyncObject;
    private final PeripheralAttachmentManager attachmentManager;
    private final PeripheralEntryPool peripheralEntryPool;
    private final Model model;

    @Inject
    public StandardPeripheralService(TCSObjectService objectService, @GlobalSyncObject Object globalSyncObject, PeripheralAttachmentManager attachmentManager, PeripheralEntryPool peripheralEntryPool, Model model) {
        super(objectService);
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.attachmentManager = Objects.requireNonNull(attachmentManager, "attachmentManager");
        this.peripheralEntryPool = Objects.requireNonNull(peripheralEntryPool, "peripheralEntryPool");
        this.model = Objects.requireNonNull(model, "model");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachCommAdapter(TCSResourceReference<Location> ref, PeripheralCommAdapterDescription description) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.attachmentManager.attachAdapterToLocation(ref, description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCommAdapter(TCSResourceReference<Location> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.peripheralEntryPool.getEntryFor(ref).getCommAdapter().disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCommAdapter(TCSResourceReference<Location> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.peripheralEntryPool.getEntryFor(ref).getCommAdapter().enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeripheralAttachmentInformation fetchAttachmentInformation(TCSResourceReference<Location> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.attachmentManager.getAttachmentInformation(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeripheralProcessModel fetchProcessModel(TCSResourceReference<Location> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.peripheralEntryPool.getEntryFor(ref).getCommAdapter().getProcessModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommAdapterCommand(TCSResourceReference<Location> ref, PeripheralAdapterCommand command) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            PeripheralEntry entry = this.peripheralEntryPool.getEntryFor(ref);
            PeripheralCommAdapter peripheralCommAdapter = entry.getCommAdapter();
            synchronized (peripheralCommAdapter) {
                entry.getCommAdapter().execute(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePeripheralProcState(TCSResourceReference<Location> ref, PeripheralInformation.ProcState state) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setLocationProcState((TCSObjectReference<Location>)ref, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePeripheralReservationToken(TCSResourceReference<Location> ref, String reservationToken) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setLocationReservationToken((TCSObjectReference<Location>)ref, reservationToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePeripheralState(TCSResourceReference<Location> ref, PeripheralInformation.State state) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setLocationState((TCSObjectReference<Location>)ref, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePeripheralJob(TCSResourceReference<Location> ref, TCSObjectReference<PeripheralJob> peripheralJob) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setLocationPeripheralJob((TCSObjectReference<Location>)ref, peripheralJob);
        }
    }
}

