/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.components.kernel.PeripheralJobDispatcher;
import org.opentcs.components.kernel.services.PeripheralDispatcherService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.kernel.workingset.TCSObjectPool;

public class StandardPeripheralDispatcherService
implements PeripheralDispatcherService {
    private final Object globalSyncObject;
    private final TCSObjectPool globalObjectPool;
    private final PeripheralJobDispatcher dispatcher;

    @Inject
    public StandardPeripheralDispatcherService(@GlobalSyncObject Object globalSyncObject, TCSObjectPool globalObjectPool, PeripheralJobDispatcher dispatcher) {
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.globalObjectPool = Objects.requireNonNull(globalObjectPool, "globalObjectPool");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.dispatcher.dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withdrawByLocation(TCSResourceReference<Location> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.dispatcher.withdrawJob(this.globalObjectPool.getObject(Location.class, ref));
        }
    }
}

