/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentcs.access.CredentialsException;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;

public abstract class AbstractTCSObjectService
implements TCSObjectService {
    private final TCSObjectService objectService;

    public AbstractTCSObjectService(TCSObjectService objectService) {
        this.objectService = Objects.requireNonNull(objectService, "objectService");
    }

    public <T extends TCSObject<T>> T fetchObject(Class<T> clazz, TCSObjectReference<T> ref) throws CredentialsException {
        return (T)this.getObjectService().fetchObject(clazz, ref);
    }

    public <T extends TCSObject<T>> T fetchObject(Class<T> clazz, String name) throws CredentialsException {
        return (T)this.getObjectService().fetchObject(clazz, name);
    }

    public <T extends TCSObject<T>> Set<T> fetchObjects(Class<T> clazz) throws CredentialsException {
        return this.getObjectService().fetchObjects(clazz);
    }

    public <T extends TCSObject<T>> Set<T> fetchObjects(@Nonnull Class<T> clazz, @Nonnull Predicate<? super T> predicate) throws CredentialsException {
        return this.getObjectService().fetchObjects(clazz, predicate);
    }

    public void updateObjectProperty(TCSObjectReference<?> ref, String key, @Nullable String value) throws ObjectUnknownException, CredentialsException {
        this.getObjectService().updateObjectProperty(ref, key, value);
    }

    public void appendObjectHistoryEntry(TCSObjectReference<?> ref, ObjectHistory.Entry entry) throws ObjectUnknownException, KernelRuntimeException {
        this.getObjectService().appendObjectHistoryEntry(ref, entry);
    }

    public TCSObjectService getObjectService() {
        return this.objectService;
    }
}

