/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.peripherals;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentcs.components.Lifecycle;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.kernel.peripherals.PeripheralEntry;
import org.opentcs.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralEntryPool
implements Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralEntryPool.class);
    private final TCSObjectService objectService;
    private final Map<TCSResourceReference<Location>, PeripheralEntry> entries = new HashMap<TCSResourceReference<Location>, PeripheralEntry>();
    private boolean initialized;

    @Inject
    public PeripheralEntryPool(@Nonnull TCSObjectService objectService) {
        this.objectService = Objects.requireNonNull(objectService, "objectService");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.objectService.fetchObjects(Location.class).stream().forEach(location -> this.entries.put((TCSResourceReference<Location>)location.getReference(), new PeripheralEntry((Location)location)));
        LOG.debug("Initialized peripheral entry pool: {}", this.entries);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.entries.clear();
        this.initialized = false;
    }

    @Nonnull
    public Map<TCSResourceReference<Location>, PeripheralEntry> getEntries() {
        return this.entries;
    }

    @Nonnull
    public PeripheralEntry getEntryFor(@Nonnull TCSResourceReference<Location> location) throws IllegalArgumentException {
        Objects.requireNonNull(location, "location");
        Assertions.checkArgument((boolean)this.entries.containsKey(location), (String)"No peripheral entry present for %s", (Object[])new Object[]{location.getName()});
        return this.entries.get(location);
    }
}

