/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel;

import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.opentcs.components.kernel.OrderSequenceCleanupApproval;
import org.opentcs.components.kernel.TransportOrderCleanupApproval;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.kernel.OrderPoolConfiguration;
import org.opentcs.kernel.workingset.TransportOrderPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OrderCleanerTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(OrderCleanerTask.class);
    private final Object globalSyncObject;
    private final TransportOrderPool orderPool;
    private final Set<TransportOrderCleanupApproval> orderCleanupApprovals;
    private final Set<OrderSequenceCleanupApproval> sequenceCleanupApprovals;
    private final OrderPoolConfiguration configuration;

    @Inject
    public OrderCleanerTask(@GlobalSyncObject Object globalSyncObject, TransportOrderPool orderPool, Set<TransportOrderCleanupApproval> orderCleanupApprovals, Set<OrderSequenceCleanupApproval> sequenceCleanupApprovals, OrderPoolConfiguration configuration) {
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.orderPool = Objects.requireNonNull(orderPool, "orderPool");
        this.orderCleanupApprovals = Objects.requireNonNull(orderCleanupApprovals, "orderCleanupApprovals");
        this.sequenceCleanupApprovals = Objects.requireNonNull(sequenceCleanupApprovals, "sequenceCleanupApprovals");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public long getSweepInterval() {
        return this.configuration.sweepInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.globalSyncObject;
        synchronized (object) {
            LOG.debug("Sweeping order pool...");
            Instant creationTimeThreshold = Instant.now().minusMillis(this.configuration.sweepAge());
            for (TransportOrder transportOrder : this.orderPool.getObjectPool().getObjects(TransportOrder.class, new OrderApproval(creationTimeThreshold))) {
                this.orderPool.removeTransportOrder((TCSObjectReference<TransportOrder>)transportOrder.getReference());
            }
            for (OrderSequence orderSequence : this.orderPool.getObjectPool().getObjects(OrderSequence.class, new SequenceApproval(creationTimeThreshold))) {
                this.orderPool.removeFinishedOrderSequenceAndOrders((TCSObjectReference<OrderSequence>)orderSequence.getReference());
            }
        }
    }

    private class OrderApproval
    implements Predicate<TransportOrder> {
        private final Instant creationTimeThreshold;

        public OrderApproval(Instant creationTimeThreshold) {
            this.creationTimeThreshold = creationTimeThreshold;
        }

        @Override
        public boolean test(TransportOrder order) {
            if (!order.getState().isFinalState()) {
                return false;
            }
            if (order.getWrappingSequence() != null) {
                return false;
            }
            if (order.getCreationTime().isAfter(this.creationTimeThreshold)) {
                return false;
            }
            for (TransportOrderCleanupApproval approval : OrderCleanerTask.this.orderCleanupApprovals) {
                if (approval.test((Object)order)) continue;
                return false;
            }
            return true;
        }
    }

    private class SequenceApproval
    implements Predicate<OrderSequence> {
        private final Instant creationTimeThreshold;

        public SequenceApproval(Instant creationTimeThreshold) {
            this.creationTimeThreshold = creationTimeThreshold;
        }

        @Override
        public boolean test(OrderSequence seq) {
            TransportOrder lastOrder;
            if (!seq.isFinished()) {
                return false;
            }
            List orderRefs = seq.getOrders();
            if (!orderRefs.isEmpty() && (lastOrder = OrderCleanerTask.this.orderPool.getObjectPool().getObject(TransportOrder.class, (TCSObjectReference)Iterables.getLast((Iterable)orderRefs))).getCreationTime().isAfter(this.creationTimeThreshold)) {
                return false;
            }
            for (OrderSequenceCleanupApproval approval : OrderCleanerTask.this.sequenceCleanupApprovals) {
                if (approval.test((Object)seq)) continue;
                return false;
            }
            return true;
        }
    }
}

