/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel;

import com.google.inject.Binder;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.MapBinder;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Singleton;
import org.opentcs.access.Kernel;
import org.opentcs.access.LocalKernel;
import org.opentcs.access.SslParameterSet;
import org.opentcs.common.LoggingScheduledThreadPoolExecutor;
import org.opentcs.components.kernel.ObjectNameProvider;
import org.opentcs.components.kernel.services.DispatcherService;
import org.opentcs.components.kernel.services.InternalPeripheralJobService;
import org.opentcs.components.kernel.services.InternalPeripheralService;
import org.opentcs.components.kernel.services.InternalPlantModelService;
import org.opentcs.components.kernel.services.InternalQueryService;
import org.opentcs.components.kernel.services.InternalTransportOrderService;
import org.opentcs.components.kernel.services.InternalVehicleService;
import org.opentcs.components.kernel.services.NotificationService;
import org.opentcs.components.kernel.services.PeripheralDispatcherService;
import org.opentcs.components.kernel.services.PeripheralJobService;
import org.opentcs.components.kernel.services.PeripheralService;
import org.opentcs.components.kernel.services.PlantModelService;
import org.opentcs.components.kernel.services.QueryService;
import org.opentcs.components.kernel.services.RouterService;
import org.opentcs.components.kernel.services.SchedulerService;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.components.kernel.services.TransportOrderService;
import org.opentcs.components.kernel.services.VehicleService;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.ApplicationHome;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.customizations.kernel.KernelExecutor;
import org.opentcs.customizations.kernel.KernelInjectionModule;
import org.opentcs.drivers.peripherals.PeripheralControllerPool;
import org.opentcs.drivers.vehicle.VehicleControllerPool;
import org.opentcs.kernel.KernelApplicationConfiguration;
import org.opentcs.kernel.KernelState;
import org.opentcs.kernel.KernelStateModelling;
import org.opentcs.kernel.KernelStateOperating;
import org.opentcs.kernel.KernelStateShutdown;
import org.opentcs.kernel.OrderPoolConfiguration;
import org.opentcs.kernel.SslConfiguration;
import org.opentcs.kernel.StandardKernel;
import org.opentcs.kernel.extensions.controlcenter.vehicles.AttachmentManager;
import org.opentcs.kernel.extensions.controlcenter.vehicles.VehicleEntryPool;
import org.opentcs.kernel.peripherals.DefaultPeripheralControllerPool;
import org.opentcs.kernel.peripherals.LocalPeripheralControllerPool;
import org.opentcs.kernel.peripherals.PeripheralAttachmentManager;
import org.opentcs.kernel.peripherals.PeripheralCommAdapterRegistry;
import org.opentcs.kernel.peripherals.PeripheralControllerFactory;
import org.opentcs.kernel.peripherals.PeripheralEntryPool;
import org.opentcs.kernel.persistence.ModelPersister;
import org.opentcs.kernel.persistence.XMLFileModelPersister;
import org.opentcs.kernel.services.StandardDispatcherService;
import org.opentcs.kernel.services.StandardNotificationService;
import org.opentcs.kernel.services.StandardPeripheralDispatcherService;
import org.opentcs.kernel.services.StandardPeripheralJobService;
import org.opentcs.kernel.services.StandardPeripheralService;
import org.opentcs.kernel.services.StandardPlantModelService;
import org.opentcs.kernel.services.StandardQueryService;
import org.opentcs.kernel.services.StandardRouterService;
import org.opentcs.kernel.services.StandardSchedulerService;
import org.opentcs.kernel.services.StandardTCSObjectService;
import org.opentcs.kernel.services.StandardTransportOrderService;
import org.opentcs.kernel.services.StandardVehicleService;
import org.opentcs.kernel.vehicles.DefaultVehicleControllerPool;
import org.opentcs.kernel.vehicles.LocalVehicleControllerPool;
import org.opentcs.kernel.vehicles.VehicleCommAdapterRegistry;
import org.opentcs.kernel.vehicles.VehicleControllerComponentsFactory;
import org.opentcs.kernel.vehicles.VehicleControllerFactory;
import org.opentcs.kernel.workingset.Model;
import org.opentcs.kernel.workingset.NotificationBuffer;
import org.opentcs.kernel.workingset.PeripheralJobPool;
import org.opentcs.kernel.workingset.PrefixedUlidObjectNameProvider;
import org.opentcs.kernel.workingset.TCSObjectPool;
import org.opentcs.kernel.workingset.TransportOrderPool;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.event.EventSource;
import org.opentcs.util.event.SimpleEventBus;
import org.opentcs.util.logging.UncaughtExceptionLogger;

public class DefaultKernelInjectionModule
extends KernelInjectionModule {
    protected void configure() {
        this.configureEventHub();
        this.configureKernelExecutor();
        File applicationHome = new File(System.getProperty("opentcs.home", "."));
        this.bind(File.class).annotatedWith(ApplicationHome.class).toInstance((Object)applicationHome);
        this.bind(Object.class).annotatedWith(GlobalSyncObject.class).to(Object.class).in(Singleton.class);
        this.bind(TCSObjectPool.class).in(Singleton.class);
        this.bind(Model.class).in(Singleton.class);
        this.bind(TransportOrderPool.class).in(Singleton.class);
        this.bind(PeripheralJobPool.class).in(Singleton.class);
        this.bind(NotificationBuffer.class).in(Singleton.class);
        this.bind(ObjectNameProvider.class).to(PrefixedUlidObjectNameProvider.class).in(Singleton.class);
        this.configurePersistence();
        this.bind(VehicleCommAdapterRegistry.class).in(Singleton.class);
        this.configureVehicleControllers();
        this.bind(AttachmentManager.class).in(Singleton.class);
        this.bind(VehicleEntryPool.class).in(Singleton.class);
        this.configurePeripheralControllers();
        this.bind(PeripheralCommAdapterRegistry.class).in(Singleton.class);
        this.bind(PeripheralAttachmentManager.class).in(Singleton.class);
        this.bind(PeripheralEntryPool.class).in(Singleton.class);
        this.bind(StandardKernel.class).in(Singleton.class);
        this.bind(LocalKernel.class).to(StandardKernel.class);
        this.configureKernelStatesDependencies();
        this.configureKernelStarterDependencies();
        this.configureSslParameters();
        this.configureKernelServicesDependencies();
        this.extensionsBinderAllModes();
        this.extensionsBinderModelling();
        this.extensionsBinderOperating();
        this.vehicleCommAdaptersBinder();
        this.peripheralCommAdaptersBinder();
    }

    private void configureKernelServicesDependencies() {
        this.bind(StandardPlantModelService.class).in(Singleton.class);
        this.bind(PlantModelService.class).to(StandardPlantModelService.class);
        this.bind(InternalPlantModelService.class).to(StandardPlantModelService.class);
        this.bind(StandardTransportOrderService.class).in(Singleton.class);
        this.bind(TransportOrderService.class).to(StandardTransportOrderService.class);
        this.bind(InternalTransportOrderService.class).to(StandardTransportOrderService.class);
        this.bind(StandardVehicleService.class).in(Singleton.class);
        this.bind(VehicleService.class).to(StandardVehicleService.class);
        this.bind(InternalVehicleService.class).to(StandardVehicleService.class);
        this.bind(StandardTCSObjectService.class).in(Singleton.class);
        this.bind(TCSObjectService.class).to(StandardTCSObjectService.class);
        this.bind(StandardNotificationService.class).in(Singleton.class);
        this.bind(NotificationService.class).to(StandardNotificationService.class);
        this.bind(StandardRouterService.class).in(Singleton.class);
        this.bind(RouterService.class).to(StandardRouterService.class);
        this.bind(StandardDispatcherService.class).in(Singleton.class);
        this.bind(DispatcherService.class).to(StandardDispatcherService.class);
        this.bind(StandardSchedulerService.class).in(Singleton.class);
        this.bind(SchedulerService.class).to(StandardSchedulerService.class);
        this.bind(StandardQueryService.class).in(Singleton.class);
        this.bind(QueryService.class).to(StandardQueryService.class);
        this.bind(InternalQueryService.class).to(StandardQueryService.class);
        this.bind(StandardPeripheralService.class).in(Singleton.class);
        this.bind(PeripheralService.class).to(StandardPeripheralService.class);
        this.bind(InternalPeripheralService.class).to(StandardPeripheralService.class);
        this.bind(StandardPeripheralJobService.class).in(Singleton.class);
        this.bind(PeripheralJobService.class).to(StandardPeripheralJobService.class);
        this.bind(InternalPeripheralJobService.class).to(StandardPeripheralJobService.class);
        this.bind(StandardPeripheralDispatcherService.class).in(Singleton.class);
        this.bind(PeripheralDispatcherService.class).to(StandardPeripheralDispatcherService.class);
    }

    private void configureVehicleControllers() {
        this.install(new FactoryModuleBuilder().build(VehicleControllerFactory.class));
        this.install(new FactoryModuleBuilder().build(VehicleControllerComponentsFactory.class));
        this.bind(DefaultVehicleControllerPool.class).in(Singleton.class);
        this.bind(VehicleControllerPool.class).to(DefaultVehicleControllerPool.class);
        this.bind(LocalVehicleControllerPool.class).to(DefaultVehicleControllerPool.class);
    }

    private void configurePeripheralControllers() {
        this.install(new FactoryModuleBuilder().build(PeripheralControllerFactory.class));
        this.bind(DefaultPeripheralControllerPool.class).in(Singleton.class);
        this.bind(PeripheralControllerPool.class).to(DefaultPeripheralControllerPool.class);
        this.bind(LocalPeripheralControllerPool.class).to(DefaultPeripheralControllerPool.class);
    }

    private void configurePersistence() {
        this.bind(ModelPersister.class).to(XMLFileModelPersister.class);
    }

    private void configureEventHub() {
        SimpleEventBus newEventBus = new SimpleEventBus();
        this.bind(EventHandler.class).annotatedWith(ApplicationEventBus.class).toInstance((Object)newEventBus);
        this.bind(EventSource.class).annotatedWith(ApplicationEventBus.class).toInstance((Object)newEventBus);
        this.bind(EventBus.class).annotatedWith(ApplicationEventBus.class).toInstance((Object)newEventBus);
    }

    private void configureKernelStatesDependencies() {
        MapBinder stateMapBinder = MapBinder.newMapBinder((Binder)this.binder(), Kernel.State.class, KernelState.class);
        stateMapBinder.addBinding((Object)Kernel.State.SHUTDOWN).to(KernelStateShutdown.class);
        stateMapBinder.addBinding((Object)Kernel.State.MODELLING).to(KernelStateModelling.class);
        stateMapBinder.addBinding((Object)Kernel.State.OPERATING).to(KernelStateOperating.class);
        this.bind(OrderPoolConfiguration.class).toInstance((Object)((OrderPoolConfiguration)this.getConfigBindingProvider().get("orderpool", OrderPoolConfiguration.class)));
        this.transportOrderCleanupApprovalBinder();
        this.orderSequenceCleanupApprovalBinder();
    }

    private void configureKernelStarterDependencies() {
        this.bind(KernelApplicationConfiguration.class).toInstance((Object)((KernelApplicationConfiguration)this.getConfigBindingProvider().get("kernelapp", KernelApplicationConfiguration.class)));
    }

    private void configureSslParameters() {
        SslConfiguration configuration = (SslConfiguration)this.getConfigBindingProvider().get("ssl", SslConfiguration.class);
        SslParameterSet sslParamSet = new SslParameterSet("PKCS12", new File(configuration.keystoreFile()), configuration.keystorePassword(), new File(configuration.truststoreFile()), configuration.truststorePassword());
        this.bind(SslParameterSet.class).toInstance((Object)sslParamSet);
    }

    private void configureKernelExecutor() {
        LoggingScheduledThreadPoolExecutor executor = new LoggingScheduledThreadPoolExecutor(1, runnable -> {
            Thread thread = new Thread(runnable, "kernelExecutor");
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionLogger(false));
            return thread;
        });
        this.bind(ScheduledExecutorService.class).annotatedWith(KernelExecutor.class).toInstance((Object)executor);
        this.bind(ExecutorService.class).annotatedWith(KernelExecutor.class).toInstance((Object)executor);
        this.bind(Executor.class).annotatedWith(KernelExecutor.class).toInstance((Object)executor);
    }
}

