/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.persistence.v005;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.data.model.visualization.LocationRepresentation;
import org.opentcs.util.persistence.v004.V004ModelParser;
import org.opentcs.util.persistence.v004.V004PlantModelTO;
import org.opentcs.util.persistence.v005.AllowedOperationTO;
import org.opentcs.util.persistence.v005.AllowedPeripheralOperationTO;
import org.opentcs.util.persistence.v005.BlockTO;
import org.opentcs.util.persistence.v005.CoupleTO;
import org.opentcs.util.persistence.v005.LocationTO;
import org.opentcs.util.persistence.v005.LocationTypeTO;
import org.opentcs.util.persistence.v005.MemberTO;
import org.opentcs.util.persistence.v005.PathTO;
import org.opentcs.util.persistence.v005.PeripheralOperationTO;
import org.opentcs.util.persistence.v005.PointTO;
import org.opentcs.util.persistence.v005.PropertyTO;
import org.opentcs.util.persistence.v005.V005PlantModelTO;
import org.opentcs.util.persistence.v005.V005TOMapper;
import org.opentcs.util.persistence.v005.VehicleEnvelopeTO;
import org.opentcs.util.persistence.v005.VehicleTO;
import org.opentcs.util.persistence.v005.VisualLayoutTO;

public class V005ModelParser {
    public PlantModelCreationTO read(Reader reader, String modelVersion) throws IOException {
        return new V005TOMapper().map(this.readRaw(reader, modelVersion));
    }

    public V005PlantModelTO readRaw(Reader reader, String modelVersion) throws IOException {
        if (Objects.equals(modelVersion, "0.0.5")) {
            return V005PlantModelTO.fromXml(reader);
        }
        return this.convert(new V004ModelParser().readRaw(reader, modelVersion));
    }

    private V005PlantModelTO convert(V004PlantModelTO to) {
        return new V005PlantModelTO().setName(to.getName()).setPoints(this.convertPoints(to)).setPaths(this.convertPaths(to)).setVehicles(this.convertVehicles(to)).setLocationTypes(this.convertLocationTypes(to)).setLocations(this.convertLocations(to)).setBlocks(this.convertBlocks(to)).setVisualLayout(this.convertVisualLayout(to)).setProperties(this.convertProperties(to.getProperties()));
    }

    private List<PropertyTO> convertProperties(List<org.opentcs.util.persistence.v004.PropertyTO> tos) {
        return tos.stream().map(property -> new PropertyTO().setName(property.getName()).setValue(property.getValue())).toList();
    }

    private List<PointTO> convertPoints(V004PlantModelTO to) {
        return to.getPoints().stream().map(point -> {
            PointTO result = new PointTO();
            result.setName(point.getName()).setProperties(this.convertProperties(point.getProperties()));
            result.setxPosition(point.getxPosition()).setyPosition(point.getyPosition()).setzPosition(point.getzPosition()).setVehicleOrientationAngle(point.getVehicleOrientationAngle()).setType(point.getType()).setVehicleEnvelopes(this.convertVehicleEnvelopes(point.getVehicleEnvelopes())).setOutgoingPaths(this.convertOutgoingPaths((org.opentcs.util.persistence.v004.PointTO)point)).setPointLayout(new PointTO.PointLayout().setxPosition(point.getPointLayout().getxPosition()).setyPosition(point.getPointLayout().getyPosition()).setxLabelOffset(point.getPointLayout().getxLabelOffset()).setyLabelOffset(point.getPointLayout().getyLabelOffset()));
            return result;
        }).toList();
    }

    private List<VehicleEnvelopeTO> convertVehicleEnvelopes(List<org.opentcs.util.persistence.v004.VehicleEnvelopeTO> tos) {
        return tos.stream().map(vehicleEnvelope -> new VehicleEnvelopeTO().setKey(vehicleEnvelope.getKey()).setVertices(vehicleEnvelope.getVertices().stream().map(couple -> new CoupleTO().setX(couple.getX()).setY(couple.getY())).toList())).toList();
    }

    private Map<String, String> toPropertiesMap(List<org.opentcs.util.persistence.v004.PropertyTO> properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (org.opentcs.util.persistence.v004.PropertyTO property : properties) {
            result.put(property.getName(), property.getValue());
        }
        return result;
    }

    private List<PointTO.OutgoingPath> convertOutgoingPaths(org.opentcs.util.persistence.v004.PointTO to) {
        return to.getOutgoingPaths().stream().map(path -> new PointTO.OutgoingPath().setName(path.getName())).toList();
    }

    private List<PathTO> convertPaths(V004PlantModelTO to) {
        return to.getPaths().stream().map(path -> {
            PathTO result = new PathTO();
            result.setName(path.getName()).setProperties(this.convertProperties(path.getProperties()));
            result.setSourcePoint(path.getSourcePoint()).setDestinationPoint(path.getDestinationPoint()).setLength(path.getLength()).setMaxVelocity(path.getMaxVelocity()).setMaxReverseVelocity(path.getMaxReverseVelocity()).setPeripheralOperations(this.convertPeripheralOperations(path.getPeripheralOperations())).setLocked(path.isLocked()).setVehicleEnvelopes(this.convertVehicleEnvelopes(path.getVehicleEnvelopes())).setPathLayout(new PathTO.PathLayout().setConnectionType(path.getPathLayout().getConnectionType()).setControlPoints(path.getPathLayout().getControlPoints().stream().map(controlPoint -> new PathTO.ControlPoint().setX(controlPoint.getX()).setY(controlPoint.getY())).toList()));
            return result;
        }).toList();
    }

    private List<PeripheralOperationTO> convertPeripheralOperations(List<org.opentcs.util.persistence.v004.PeripheralOperationTO> tos) {
        return tos.stream().map(peripheralOperation -> {
            PeripheralOperationTO result = new PeripheralOperationTO();
            result.setName(peripheralOperation.getName()).setProperties(this.convertProperties(peripheralOperation.getProperties()));
            result.setLocationName(peripheralOperation.getLocationName()).setExecutionTrigger(peripheralOperation.getExecutionTrigger()).setCompletionRequired(peripheralOperation.isCompletionRequired());
            return result;
        }).toList();
    }

    private List<VehicleTO> convertVehicles(V004PlantModelTO to) {
        return to.getVehicles().stream().map(vehicle -> {
            VehicleTO result = new VehicleTO();
            result.setName(vehicle.getName()).setProperties(this.convertProperties(vehicle.getProperties()));
            result.setLength(vehicle.getLength()).setEnergyLevelCritical(vehicle.getEnergyLevelCritical()).setEnergyLevelGood(vehicle.getEnergyLevelGood()).setEnergyLevelFullyRecharged(vehicle.getEnergyLevelFullyRecharged()).setEnergyLevelSufficientlyRecharged(vehicle.getEnergyLevelSufficientlyRecharged()).setMaxVelocity(vehicle.getMaxVelocity()).setMaxReverseVelocity(vehicle.getMaxReverseVelocity()).setEnvelopeKey(vehicle.getEnvelopeKey()).setVehicleLayout(new VehicleTO.VehicleLayout().setColor(vehicle.getVehicleLayout().getColor()));
            return result;
        }).toList();
    }

    private List<LocationTypeTO> convertLocationTypes(V004PlantModelTO to) {
        return to.getLocationTypes().stream().map(locationType -> {
            String locationRepresentation = this.toPropertiesMap(locationType.getProperties()).getOrDefault("tcs:defaultLocationTypeSymbol", LocationRepresentation.NONE.name());
            LocationTypeTO result = new LocationTypeTO();
            result.setName(locationType.getName()).setProperties(this.convertProperties(locationType.getProperties()));
            result.setAllowedOperations(this.convertAllowedOperations(locationType.getAllowedOperations())).setAllowedPeripheralOperations(this.convertAllowedPeripheralOperations(locationType.getAllowedPeripheralOperations())).setLocationTypeLayout(new LocationTypeTO.LocationTypeLayout().setLocationRepresentation(locationRepresentation));
            return result;
        }).toList();
    }

    private List<AllowedOperationTO> convertAllowedOperations(List<org.opentcs.util.persistence.v004.AllowedOperationTO> tos) {
        return tos.stream().map(allowedOperation -> {
            AllowedOperationTO result = new AllowedOperationTO();
            result.setName(allowedOperation.getName());
            result.setProperties(this.convertProperties(allowedOperation.getProperties()));
            return result;
        }).toList();
    }

    private List<AllowedPeripheralOperationTO> convertAllowedPeripheralOperations(List<org.opentcs.util.persistence.v004.AllowedPeripheralOperationTO> tos) {
        return tos.stream().map(allowedPeripheralOperation -> {
            AllowedPeripheralOperationTO result = new AllowedPeripheralOperationTO();
            result.setName(allowedPeripheralOperation.getName());
            result.setProperties(this.convertProperties(allowedPeripheralOperation.getProperties()));
            return result;
        }).toList();
    }

    private List<LocationTO> convertLocations(V004PlantModelTO to) {
        return to.getLocations().stream().map(location -> {
            String locationRepresentation = this.toPropertiesMap(location.getProperties()).getOrDefault("tcs:defaultLocationSymbol", LocationRepresentation.DEFAULT.name());
            LocationTO result = new LocationTO();
            result.setName(location.getName()).setProperties(this.convertProperties(location.getProperties()));
            result.setxPosition(location.getxPosition()).setyPosition(location.getyPosition()).setzPosition(location.getzPosition()).setType(location.getType()).setLinks(this.convertLinks((org.opentcs.util.persistence.v004.LocationTO)location)).setLocked(location.isLocked()).setLocationLayout(new LocationTO.LocationLayout().setxPosition(location.getLocationLayout().getxPosition()).setyPosition(location.getLocationLayout().getyPosition()).setxLabelOffset(location.getLocationLayout().getxLabelOffset()).setyLabelOffset(location.getLocationLayout().getyLabelOffset()).setLocationRepresentation(locationRepresentation));
            return result;
        }).toList();
    }

    private List<LocationTO.Link> convertLinks(org.opentcs.util.persistence.v004.LocationTO to) {
        return to.getLinks().stream().map(link -> new LocationTO.Link().setPoint(link.getPoint()).setAllowedOperations(this.convertAllowedOperations(link.getAllowedOperations()))).toList();
    }

    private List<BlockTO> convertBlocks(V004PlantModelTO to) {
        return to.getBlocks().stream().map(block -> {
            BlockTO result = new BlockTO();
            result.setName(block.getName()).setProperties(this.convertProperties(block.getProperties()));
            result.setType(block.getType()).setMembers(this.convertMembers(block.getMembers())).setBlockLayout(new BlockTO.BlockLayout().setColor(block.getBlockLayout().getColor()));
            return result;
        }).toList();
    }

    private List<MemberTO> convertMembers(List<org.opentcs.util.persistence.v004.MemberTO> tos) {
        return tos.stream().map(member -> {
            MemberTO result = new MemberTO();
            result.setName(member.getName()).setProperties(this.convertProperties(member.getProperties()));
            return result;
        }).toList();
    }

    private VisualLayoutTO convertVisualLayout(V004PlantModelTO to) {
        VisualLayoutTO result = new VisualLayoutTO().setScaleX(to.getVisualLayout().getScaleX()).setScaleY(to.getVisualLayout().getScaleY()).setLayers(to.getVisualLayout().getLayers().stream().map(layer -> new VisualLayoutTO.Layer().setId(layer.getId()).setOrdinal(layer.getOrdinal()).setVisible(layer.isVisible()).setName(layer.getName()).setGroupId(layer.getGroupId())).toList()).setLayerGroups(to.getVisualLayout().getLayerGroups().stream().map(layerGroup -> new VisualLayoutTO.LayerGroup().setId(layerGroup.getId()).setName(layerGroup.getName()).setVisible(layerGroup.isVisible())).toList());
        result.setProperties(this.convertProperties(to.getVisualLayout().getProperties())).setName(to.getVisualLayout().getName());
        return result;
    }
}

