/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.gui;

import java.awt.Component;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class StringListCellRenderer<E>
implements ListCellRenderer<E> {
    private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private final Function<E, String> representer;

    public StringListCellRenderer(Function<E, String> representer) {
        this.representer = Objects.requireNonNull(representer, "representer");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, (Object)value, index, isSelected, cellHasFocus);
        label.setText(this.representer.apply(value));
        return label;
    }
}

