/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.gui;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Icons {
    private static final Logger LOG = LoggerFactory.getLogger(Icons.class);
    private static final String ICON_PATH = "/org/opentcs/util/gui/res/icons/";
    private static final String[] ICON_FILES = new String[]{"opentcs_icon_016.png", "opentcs_icon_032.png", "opentcs_icon_064.png", "opentcs_icon_128.png", "opentcs_icon_256.png"};

    private Icons() {
    }

    public static List<Image> getOpenTCSIcons() {
        try {
            ArrayList<Image> icons = new ArrayList<Image>();
            for (String iconFile : ICON_FILES) {
                String iconURL = ICON_PATH + iconFile;
                BufferedImage icon = ImageIO.read(Icons.class.getResource(iconURL));
                icons.add(icon);
            }
            return icons;
        }
        catch (IOException | IllegalArgumentException exc) {
            LOG.warn("Couldn't load icon images from path {}", (Object)ICON_PATH, (Object)exc);
            return new ArrayList<Image>();
        }
    }
}

