/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Environment {
    private static final String BASELINE_PROPS_FILE = "/opentcs.properties";
    private static final String CUSTOMIZATION_PROPS_FILE = "/opentcs-customization.properties";
    private static final String BASELINE_VERSION;
    private static final String BASELINE_BUILD_DATE;
    private static final String CUSTOMIZATION_NAME;
    private static final String CUSTOMIZATION_VERSION;
    private static final String CUSTOMIZATION_BUILD_DATE;
    private static final Logger LOG;

    private Environment() {
    }

    public static String getBaselineVersion() {
        return BASELINE_VERSION;
    }

    public static String getBaselineBuildDate() {
        return BASELINE_BUILD_DATE;
    }

    public static String getCustomizationName() {
        return CUSTOMIZATION_NAME;
    }

    public static String getCustomizationVersion() {
        return CUSTOMIZATION_VERSION;
    }

    public static String getCustomizationBuildDate() {
        return CUSTOMIZATION_BUILD_DATE;
    }

    public static void logSystemInfo() {
        LOG.info("openTCS baseline version: {} (build date: {}), customization '{}' version {} (build date: {}), Java: {}, {}; JVM: {}, {}; OS: {}, {}", new Object[]{BASELINE_VERSION, BASELINE_BUILD_DATE, CUSTOMIZATION_NAME, CUSTOMIZATION_VERSION, CUSTOMIZATION_BUILD_DATE, System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.vm.version"), System.getProperty("java.vm.vendor"), System.getProperty("os.name"), System.getProperty("os.arch")});
    }

    static {
        LOG = LoggerFactory.getLogger(Environment.class);
        Properties props = new Properties();
        try {
            InputStream inStream = Environment.class.getResourceAsStream(BASELINE_PROPS_FILE);
            if (inStream != null) {
                props.load(inStream);
            }
            if ((inStream = Environment.class.getResourceAsStream(CUSTOMIZATION_PROPS_FILE)) != null) {
                props.load(inStream);
            }
        }
        catch (IOException exc) {
            throw new IllegalStateException("Could not load environment properties", exc);
        }
        BASELINE_VERSION = props.getProperty("opentcs.version", "unknown version");
        BASELINE_BUILD_DATE = props.getProperty("opentcs.builddate", "unknown build date");
        CUSTOMIZATION_NAME = props.getProperty("opentcs.customization.name", "-");
        CUSTOMIZATION_VERSION = props.getProperty("opentcs.customization.version", "-");
        CUSTOMIZATION_BUILD_DATE = props.getProperty("opentcs.customization.builddate", "-");
    }
}

