/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.common;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.opentcs.util.Assertions;

public class SameThreadExecutorService
implements ExecutorService {
    private boolean shutdown = false;

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        return List.of();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Assertions.checkState((boolean)this.shutdown, (String)"Awaiting termination before shutdown was called");
        return true;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        CompletableFuture<T> future = new CompletableFuture<T>();
        try {
            future.complete(task.call());
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit(() -> {
            task.run();
            return result;
        });
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return tasks.stream().map(task -> this.submit((Callable)task)).collect(Collectors.toList());
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.invokeAll(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Objects.requireNonNull(tasks, "tasks");
        Assertions.checkArgument((boolean)tasks.isEmpty(), (String)"tasks is empty");
        if (tasks.stream().anyMatch(task -> task == null)) {
            throw new NullPointerException("At least one task given is null");
        }
        List<Future<T>> futures = this.invokeAll(tasks);
        for (Future<T> future : futures) {
            try {
                return future.get();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception exception) {
            }
        }
        throw new ExecutionException(new Exception("None of the provided task sucessfully terminated"));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.invokeAny(tasks);
    }

    @Override
    public void execute(Runnable command) {
        command.run();
    }
}

