/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.persistence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.util.persistence.ProbePlantModelTO;
import org.opentcs.util.persistence.v004.V004ModelParser;
import org.opentcs.util.persistence.v004.V004PlantModelTO;
import org.opentcs.util.persistence.v004.V004TOMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelParser {
    private static final Logger LOG = LoggerFactory.getLogger(ModelParser.class);
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public PlantModelCreationTO readModel(File file) throws IOException {
        String modelVersion = this.peekModelVersion(file);
        LOG.debug("File '{}' contains a model version '{}'.", (Object)file.getAbsolutePath(), (Object)modelVersion);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET));){
            PlantModelCreationTO plantModelCreationTO = new V004ModelParser().read(reader, modelVersion);
            return plantModelCreationTO;
        }
    }

    public void writeModel(PlantModelCreationTO model, File file) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), CHARSET));){
            V004TOMapper mapper = new V004TOMapper();
            V004PlantModelTO mappedModel = mapper.map(model);
            mappedModel.toXml(writer);
        }
    }

    private String peekModelVersion(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET));){
            String string = ProbePlantModelTO.fromXml(reader).getVersion();
            return string;
        }
    }
}

