/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.logging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncaughtExceptionLogger
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UncaughtExceptionLogger.class);
    private final boolean doExit;

    public UncaughtExceptionLogger(boolean exitOnException) {
        this.doExit = exitOnException;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        LOG.error("Unhandled exception", e);
        if (this.doExit) {
            System.exit(1);
        }
    }
}

