/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.event;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEventBus
implements EventBus {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleEventBus.class);
    private final Set<EventHandler> listeners = new CopyOnWriteArraySet<EventHandler>();

    @Override
    public void onEvent(Object event) {
        try {
            for (EventHandler listener : this.listeners) {
                listener.onEvent(event);
            }
        }
        catch (Exception exc) {
            LOG.warn("Exception thrown by event handler", (Throwable)exc);
        }
    }

    @Override
    public void subscribe(EventHandler listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
    }

    @Override
    public void unsubscribe(EventHandler listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.remove(listener);
    }
}

