/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.vehicle.management;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;

public class VehicleAttachmentInformation
implements Serializable {
    private final TCSObjectReference<Vehicle> vehicleReference;
    private final List<VehicleCommAdapterDescription> availableCommAdapters;
    private final VehicleCommAdapterDescription attachedCommAdapter;

    public VehicleAttachmentInformation(@Nonnull TCSObjectReference<Vehicle> vehicleReference, @Nonnull List<VehicleCommAdapterDescription> availableCommAdapters, @Nonnull VehicleCommAdapterDescription attachedCommAdapter) {
        this.vehicleReference = Objects.requireNonNull(vehicleReference, "vehicleReference");
        this.availableCommAdapters = Objects.requireNonNull(availableCommAdapters, "availableCommAdapters");
        this.attachedCommAdapter = Objects.requireNonNull(attachedCommAdapter, "attachedCommAdapter");
    }

    @Nonnull
    public TCSObjectReference<Vehicle> getVehicleReference() {
        return this.vehicleReference;
    }

    public VehicleAttachmentInformation withVehicleReference(TCSObjectReference<Vehicle> vehicleReference) {
        return new VehicleAttachmentInformation(vehicleReference, this.getAvailableCommAdapters(), this.getAttachedCommAdapter());
    }

    @Nonnull
    public List<VehicleCommAdapterDescription> getAvailableCommAdapters() {
        return this.availableCommAdapters;
    }

    public VehicleAttachmentInformation withAvailableCommAdapters(@Nonnull List<VehicleCommAdapterDescription> availableCommAdapters) {
        return new VehicleAttachmentInformation(this.getVehicleReference(), availableCommAdapters, this.getAttachedCommAdapter());
    }

    @Nonnull
    public VehicleCommAdapterDescription getAttachedCommAdapter() {
        return this.attachedCommAdapter;
    }

    public VehicleAttachmentInformation withAttachedCommAdapter(@Nonnull VehicleCommAdapterDescription attachedCommAdapter) {
        return new VehicleAttachmentInformation(this.getVehicleReference(), this.getAvailableCommAdapters(), attachedCommAdapter);
    }
}

