/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.vehicle;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Point;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.Route;
import org.opentcs.data.order.TransportOrder;

public class MovementCommand {
    public static final String NO_OPERATION = "NOP";
    public static final String MOVE_OPERATION = "MOVE";
    public static final String PARK_OPERATION = "PARK";
    private final TransportOrder transportOrder;
    private final DriveOrder driveOrder;
    private final Route.Step step;
    private final String operation;
    private final Location opLocation;
    private final boolean finalMovement;
    private final Point finalDestination;
    private final Location finalDestinationLocation;
    private final String finalOperation;
    private final Map<String, String> properties;

    public MovementCommand(@Nonnull TransportOrder transportOrder, @Nonnull DriveOrder driveOrder, @Nonnull Route.Step step, @Nonnull String operation, @Nullable Location opLocation, boolean finalMovement, @Nullable Location finalDestinationLocation, @Nonnull Point finalDestination, @Nonnull String finalOperation, @Nonnull Map<String, String> properties) {
        this.transportOrder = Objects.requireNonNull(transportOrder, "transportOrder");
        this.driveOrder = Objects.requireNonNull(driveOrder, "driveOrder");
        this.step = Objects.requireNonNull(step, "step");
        this.operation = Objects.requireNonNull(operation, "operation");
        this.finalMovement = finalMovement;
        this.finalDestinationLocation = finalDestinationLocation;
        this.finalDestination = Objects.requireNonNull(finalDestination, "finalDestination");
        this.finalOperation = Objects.requireNonNull(finalOperation, "finalOperation");
        this.properties = Objects.requireNonNull(properties, "properties");
        if (opLocation == null && !this.isEmptyOperation(operation)) {
            throw new NullPointerException("opLocation is null while operation is not considered empty");
        }
        this.opLocation = opLocation;
    }

    @Nonnull
    public TransportOrder getTransportOrder() {
        return this.transportOrder;
    }

    public MovementCommand withTransportOrder(@Nonnull TransportOrder transportOrder) {
        return new MovementCommand(transportOrder, this.driveOrder, this.step, this.operation, this.opLocation, this.finalMovement, this.finalDestinationLocation, this.finalDestination, this.finalOperation, this.properties);
    }

    @Nonnull
    public DriveOrder getDriveOrder() {
        return this.driveOrder;
    }

    public MovementCommand withDriveOrder(@Nonnull DriveOrder driveOrder) {
        return new MovementCommand(this.transportOrder, driveOrder, this.step, this.operation, this.opLocation, this.finalMovement, this.finalDestinationLocation, this.finalDestination, this.finalOperation, this.properties);
    }

    @Nonnull
    public Route.Step getStep() {
        return this.step;
    }

    public MovementCommand withStep(@Nonnull Route.Step step) {
        return new MovementCommand(this.transportOrder, this.driveOrder, step, this.operation, this.opLocation, this.finalMovement, this.finalDestinationLocation, this.finalDestination, this.finalOperation, this.properties);
    }

    @Nonnull
    public String getOperation() {
        return this.operation;
    }

    public MovementCommand withOperation(@Nonnull String operation) {
        return new MovementCommand(this.transportOrder, this.driveOrder, this.step, operation, this.opLocation, this.finalMovement, this.finalDestinationLocation, this.finalDestination, this.finalOperation, this.properties);
    }

    public boolean hasEmptyOperation() {
        return this.isEmptyOperation(this.operation);
    }

    @Nullable
    public Location getOpLocation() {
        return this.opLocation;
    }

    public MovementCommand withOpLocation(@Nullable Location opLocation) {
        return new MovementCommand(this.transportOrder, this.driveOrder, this.step, this.operation, opLocation, this.finalMovement, this.finalDestinationLocation, this.finalDestination, this.finalOperation, this.properties);
    }

    public boolean isFinalMovement() {
        return this.finalMovement;
    }

    public MovementCommand withFinalMovement(boolean finalMovement) {
        return new MovementCommand(this.transportOrder, this.driveOrder, this.step, this.operation, this.opLocation, finalMovement, this.finalDestinationLocation, this.finalDestination, this.finalOperation, this.properties);
    }

    @Nonnull
    public Point getFinalDestination() {
        return this.finalDestination;
    }

    public MovementCommand withFinalDestination(@Nonnull Point finalDestination) {
        return new MovementCommand(this.transportOrder, this.driveOrder, this.step, this.operation, this.opLocation, this.finalMovement, this.finalDestinationLocation, finalDestination, this.finalOperation, this.properties);
    }

    @Nullable
    public Location getFinalDestinationLocation() {
        return this.finalDestinationLocation;
    }

    public MovementCommand withFinalDestinationLocation(@Nullable Location finalDestinationLocation) {
        return new MovementCommand(this.transportOrder, this.driveOrder, this.step, this.operation, this.opLocation, this.finalMovement, finalDestinationLocation, this.finalDestination, this.finalOperation, this.properties);
    }

    @Nonnull
    public String getFinalOperation() {
        return this.finalOperation;
    }

    public MovementCommand withFinalOperation(@Nonnull String finalOperation) {
        return new MovementCommand(this.transportOrder, this.driveOrder, this.step, this.operation, this.opLocation, this.finalMovement, this.finalDestinationLocation, this.finalDestination, finalOperation, this.properties);
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public MovementCommand withProperties(@Nonnull Map<String, String> properties) {
        return new MovementCommand(this.transportOrder, this.driveOrder, this.step, this.operation, this.opLocation, this.finalMovement, this.finalDestinationLocation, this.finalDestination, this.finalOperation, properties);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MovementCommand)) {
            return false;
        }
        MovementCommand other = (MovementCommand)o;
        return this.step.equals(other.getStep()) && this.operation.equals(other.getOperation());
    }

    public boolean equalsInMovement(MovementCommand command) {
        if (command == null) {
            return false;
        }
        return this.getStep().equalsInMovement(command.getStep()) && Objects.equals(this.getOperation(), command.getOperation());
    }

    public int hashCode() {
        return this.step.hashCode() ^ this.operation.hashCode();
    }

    public String toString() {
        return "MovementCommand{transportOrder=" + String.valueOf(this.getTransportOrder()) + ", driveOrder=" + String.valueOf(this.getDriveOrder()) + ", step=" + String.valueOf(this.getStep()) + ", operation=" + this.getOperation() + ", opLocation=" + String.valueOf(this.getOpLocation()) + ", finalMovement=" + this.isFinalMovement() + ", finalDestination=" + String.valueOf(this.getFinalDestination()) + ", finalDestinationLocation=" + String.valueOf(this.getFinalDestinationLocation()) + ", finalOperation=" + this.getFinalOperation() + ", properties=" + String.valueOf(this.getProperties()) + "}";
    }

    private boolean isEmptyOperation(String operation) {
        return NO_OPERATION.equals(operation) || MOVE_OPERATION.equals(operation) || PARK_OPERATION.equals(operation);
    }
}

