/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.drivers.vehicle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.MovementCommand;
import org.opentcs.drivers.vehicle.VehicleCommAdapter;
import org.opentcs.drivers.vehicle.VehicleProcessModel;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicVehicleCommAdapter
implements VehicleCommAdapter,
PropertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(BasicVehicleCommAdapter.class);
    private final VehicleProcessModel vehicleModel;
    private final int commandsCapacity;
    private final String rechargeOperation;
    private final ScheduledExecutorService executor;
    private boolean initialized;
    private boolean enabled;
    private final Runnable commandDispatcherTask = new CommandDispatcherTask();
    private final Queue<MovementCommand> commandQueue = new LinkedBlockingQueue<MovementCommand>();
    private final Queue<MovementCommand> sentQueue = new LinkedBlockingQueue<MovementCommand>();

    public BasicVehicleCommAdapter(VehicleProcessModel vehicleModel, int commandsCapacity, String rechargeOperation, ScheduledExecutorService executor) {
        this.vehicleModel = Objects.requireNonNull(vehicleModel, "vehicleModel");
        this.commandsCapacity = Assertions.checkInRange(commandsCapacity, 1, Integer.MAX_VALUE, "commandsCapacity");
        this.rechargeOperation = Objects.requireNonNull(rechargeOperation, "rechargeOperation");
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            LOG.debug("{}: Already initialized.", (Object)this.getName());
            return;
        }
        this.getProcessModel().addPropertyChangeListener(this);
        this.initialized = true;
    }

    @Override
    public void terminate() {
        if (!this.initialized) {
            LOG.debug("{}: Not initialized.", (Object)this.getName());
            return;
        }
        this.getProcessModel().removePropertyChangeListener(this);
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public synchronized void enable() {
        if (this.isEnabled()) {
            return;
        }
        LOG.info("Vehicle comm adapter is being enabled: {}", (Object)this.getName());
        this.connectVehicle();
        this.enabled = true;
        this.getProcessModel().setCommAdapterEnabled(true);
    }

    @Override
    public synchronized void disable() {
        if (!this.isEnabled()) {
            return;
        }
        LOG.info("Vehicle comm adapter is being disabled: {}", (Object)this.getName());
        this.disconnectVehicle();
        this.enabled = false;
        this.getProcessModel().setCommAdapterEnabled(false);
        this.getProcessModel().setState(Vehicle.State.UNKNOWN);
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public VehicleProcessModel getProcessModel() {
        return this.vehicleModel;
    }

    @Override
    public VehicleProcessModelTO createTransferableProcessModel() {
        return this.createCustomTransferableProcessModel().setName(this.getProcessModel().getName()).setCommAdapterConnected(this.getProcessModel().isCommAdapterConnected()).setCommAdapterEnabled(this.getProcessModel().isCommAdapterEnabled()).setEnergyLevel(this.getProcessModel().getEnergyLevel()).setLoadHandlingDevices(this.getProcessModel().getLoadHandlingDevices()).setNotifications(this.getProcessModel().getNotifications()).setOrientationAngle(this.getProcessModel().getOrientationAngle()).setPrecisePosition(this.getProcessModel().getPrecisePosition()).setPosition(this.getProcessModel().getPosition()).setState(this.getProcessModel().getState()).setLength(this.getProcessModel().getLength());
    }

    @Override
    public synchronized Queue<MovementCommand> getUnsentCommands() {
        return this.commandQueue;
    }

    @Override
    public synchronized Queue<MovementCommand> getSentCommands() {
        return this.sentQueue;
    }

    @Override
    public int getCommandsCapacity() {
        return this.commandsCapacity;
    }

    @Override
    public boolean canAcceptNextCommand() {
        return this.getUnsentCommands().size() + this.getSentCommands().size() < this.getCommandsCapacity();
    }

    @Override
    public String getRechargeOperation() {
        return this.rechargeOperation;
    }

    @Override
    public synchronized boolean enqueueCommand(MovementCommand newCommand) {
        Objects.requireNonNull(newCommand, "newCommand");
        if (!this.canAcceptNextCommand()) {
            return false;
        }
        LOG.debug("{}: Adding command: {}", (Object)this.getName(), (Object)newCommand);
        this.getUnsentCommands().add(newCommand);
        this.getProcessModel().commandEnqueued(newCommand);
        return true;
    }

    @Override
    public synchronized void clearCommandQueue() {
        this.getUnsentCommands().clear();
        this.getSentCommands().clear();
    }

    @Override
    public void execute(AdapterCommand command) {
        command.execute(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.COMMAND_ENQUEUED.name()) || Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.COMMAND_EXECUTED.name())) {
            this.executor.execute(this.commandDispatcherTask);
        }
    }

    public String getName() {
        return this.getProcessModel().getName();
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public abstract void sendCommand(MovementCommand var1) throws IllegalArgumentException;

    protected synchronized boolean canSendNextCommand() {
        return !this.getUnsentCommands().isEmpty();
    }

    protected abstract void connectVehicle();

    protected abstract void disconnectVehicle();

    protected abstract boolean isVehicleConnected();

    protected VehicleProcessModelTO createCustomTransferableProcessModel() {
        return new VehicleProcessModelTO();
    }

    private class CommandDispatcherTask
    implements Runnable {
        CommandDispatcherTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BasicVehicleCommAdapter basicVehicleCommAdapter = BasicVehicleCommAdapter.this;
            synchronized (basicVehicleCommAdapter) {
                if (!BasicVehicleCommAdapter.this.isEnabled()) {
                    LOG.debug("{}: Not enabled, skipping.", (Object)BasicVehicleCommAdapter.this.getName());
                    return;
                }
                if (!BasicVehicleCommAdapter.this.canSendNextCommand()) {
                    LOG.debug("{}: Cannot send another command, skipping.", (Object)BasicVehicleCommAdapter.this.getName());
                    return;
                }
                MovementCommand curCmd = BasicVehicleCommAdapter.this.getUnsentCommands().poll();
                if (curCmd == null) {
                    LOG.debug("{}: Nothing to send, skipping.", (Object)BasicVehicleCommAdapter.this.getName());
                    return;
                }
                try {
                    LOG.debug("{}: Sending command: {}", (Object)BasicVehicleCommAdapter.this.getName(), (Object)curCmd);
                    BasicVehicleCommAdapter.this.sendCommand(curCmd);
                    BasicVehicleCommAdapter.this.getSentCommands().add(curCmd);
                    BasicVehicleCommAdapter.this.getProcessModel().commandSent(curCmd);
                }
                catch (IllegalArgumentException exc) {
                    LOG.warn("{}: Failed sending command {}", new Object[]{BasicVehicleCommAdapter.this.getName(), curCmd, exc});
                    BasicVehicleCommAdapter.this.getProcessModel().commandFailed(curCmd);
                }
            }
        }
    }
}

