/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.peripherals;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;

public class PeripheralOperation
implements Serializable {
    @Nonnull
    private final TCSResourceReference<Location> location;
    @Nonnull
    private final String operation;
    @Nonnull
    private final ExecutionTrigger executionTrigger;
    private final boolean completionRequired;

    public PeripheralOperation(@Nonnull TCSResourceReference<Location> location, @Nonnull String operation, @Nonnull ExecutionTrigger executionTrigger, boolean completionRequired) {
        this.location = Objects.requireNonNull(location, "location");
        this.operation = Objects.requireNonNull(operation, "operation");
        this.executionTrigger = Objects.requireNonNull(executionTrigger, "executionTrigger");
        this.completionRequired = completionRequired;
    }

    @Nonnull
    public TCSResourceReference<Location> getLocation() {
        return this.location;
    }

    @Nonnull
    public String getOperation() {
        return this.operation;
    }

    @Nonnull
    public ExecutionTrigger getExecutionTrigger() {
        return this.executionTrigger;
    }

    public boolean isCompletionRequired() {
        return this.completionRequired;
    }

    public String toString() {
        return "PeripheralOperation{location=" + String.valueOf(this.location) + ", operation=" + this.operation + ", executionTrigger=" + String.valueOf((Object)this.executionTrigger) + ", completionRequired=" + this.completionRequired + "}";
    }

    public static enum ExecutionTrigger {
        IMMEDIATE,
        AFTER_ALLOCATION,
        AFTER_MOVEMENT;

    }
}

