/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.order;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Point;
import org.opentcs.data.order.Route;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.util.Assertions;

public class DriveOrder
implements Serializable {
    private final Destination destination;
    private TCSObjectReference<TransportOrder> transportOrder;
    private Route route;
    private State state;

    public DriveOrder(@Nonnull Destination destination) {
        this.destination = Objects.requireNonNull(destination, "destination");
        this.transportOrder = null;
        this.route = null;
        this.state = State.PRISTINE;
    }

    private DriveOrder(@Nonnull Destination destination, @Nullable TCSObjectReference<TransportOrder> transportOrder, @Nullable Route route, @Nonnull State state) {
        this.destination = Objects.requireNonNull(destination, "destination");
        this.transportOrder = transportOrder;
        this.route = route;
        this.state = Objects.requireNonNull(state, "state");
    }

    @Nonnull
    public Destination getDestination() {
        return this.destination;
    }

    @Nullable
    public TCSObjectReference<TransportOrder> getTransportOrder() {
        return this.transportOrder;
    }

    public DriveOrder withTransportOrder(@Nullable TCSObjectReference<TransportOrder> transportOrder) {
        return new DriveOrder(this.destination, transportOrder, this.route, this.state);
    }

    @Nullable
    public Route getRoute() {
        return this.route;
    }

    public DriveOrder withRoute(@Nullable Route route) {
        return new DriveOrder(this.destination, this.transportOrder, route, this.state);
    }

    @Nonnull
    public State getState() {
        return this.state;
    }

    public DriveOrder withState(@Nonnull State state) {
        return new DriveOrder(this.destination, this.transportOrder, this.route, state);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DriveOrder)) {
            return false;
        }
        DriveOrder other = (DriveOrder)obj;
        return Objects.equals(this.destination, other.destination) && Objects.equals(this.transportOrder, other.transportOrder);
    }

    public int hashCode() {
        return this.destination.hashCode() ^ this.transportOrder.hashCode();
    }

    public String toString() {
        return String.valueOf(this.route) + " -> " + String.valueOf(this.destination);
    }

    public static class Destination
    implements Serializable {
        public static final String OP_NOP = "NOP";
        public static final String OP_PARK = "PARK";
        public static final String OP_MOVE = "MOVE";
        private final TCSObjectReference<?> destination;
        private final String operation;
        private final Map<String, String> properties;

        public Destination(@Nonnull TCSObjectReference<?> destination) {
            Assertions.checkArgument(destination.getReferentClass() == Location.class || destination.getReferentClass() == Point.class, "Not a reference on a location or point: %s", destination);
            this.destination = Objects.requireNonNull(destination, "destination");
            this.operation = OP_NOP;
            this.properties = Collections.unmodifiableMap(new HashMap());
        }

        private Destination(@Nonnull TCSObjectReference<?> destination, @Nonnull Map<String, String> properties, @Nonnull String operation) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.operation = Objects.requireNonNull(operation, "operation");
            this.properties = Collections.unmodifiableMap(new HashMap<String, String>(properties));
        }

        @Nonnull
        public TCSObjectReference<?> getDestination() {
            return this.destination;
        }

        @Nonnull
        public String getOperation() {
            return this.operation;
        }

        public Destination withOperation(@Nonnull String operation) {
            return new Destination(this.destination, this.properties, operation);
        }

        @Nonnull
        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Destination withProperties(Map<String, String> properties) {
            return new Destination(this.destination, properties, this.operation);
        }

        public boolean equals(Object o) {
            if (o instanceof Destination) {
                Destination other = (Destination)o;
                return this.destination.equals(other.destination) && this.operation.equals(other.operation) && this.properties.equals(other.properties);
            }
            return false;
        }

        public int hashCode() {
            return this.destination.hashCode() ^ this.operation.hashCode();
        }

        public String toString() {
            return this.destination.getName() + ":" + this.operation;
        }
    }

    public static enum State {
        PRISTINE,
        TRAVELLING,
        OPERATING,
        FINISHED,
        FAILED;

    }
}

