/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model.visualization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.data.model.visualization.LayerGroup;

public class VisualLayout
extends TCSObject<VisualLayout>
implements Serializable {
    private final double scaleX;
    private final double scaleY;
    private final List<Layer> layers;
    private final List<LayerGroup> layerGroups;

    public VisualLayout(String name) {
        super(name);
        this.scaleX = 50.0;
        this.scaleY = 50.0;
        this.layers = List.of();
        this.layerGroups = List.of();
    }

    private VisualLayout(String name, Map<String, String> properties, ObjectHistory history, double scaleX, double scaleY, List<Layer> layers, List<LayerGroup> layerGroups) {
        super(name, properties, history);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.layers = new ArrayList<Layer>((Collection)Objects.requireNonNull(layers, "layers"));
        this.layerGroups = new ArrayList<LayerGroup>((Collection)Objects.requireNonNull(layerGroups, "layerGroups"));
    }

    public VisualLayout withProperty(String key, String value) {
        return new VisualLayout(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.scaleX, this.scaleY, this.layers, this.layerGroups);
    }

    public VisualLayout withProperties(Map<String, String> properties) {
        return new VisualLayout(this.getName(), properties, this.getHistory(), this.scaleX, this.scaleY, this.layers, this.layerGroups);
    }

    @Override
    public TCSObject<VisualLayout> withHistoryEntry(ObjectHistory.Entry entry) {
        return new VisualLayout(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.scaleX, this.scaleY, this.layers, this.layerGroups);
    }

    @Override
    public TCSObject<VisualLayout> withHistory(ObjectHistory history) {
        return new VisualLayout(this.getName(), this.getProperties(), history, this.scaleX, this.scaleY, this.layers, this.layerGroups);
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public VisualLayout withScaleX(double scaleX) {
        return new VisualLayout(this.getName(), this.getProperties(), this.getHistory(), scaleX, this.scaleY, this.layers, this.layerGroups);
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public VisualLayout withScaleY(double scaleY) {
        return new VisualLayout(this.getName(), this.getProperties(), this.getHistory(), this.scaleX, scaleY, this.layers, this.layerGroups);
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public VisualLayout withLayers(List<Layer> layers) {
        return new VisualLayout(this.getName(), this.getProperties(), this.getHistory(), this.scaleX, this.scaleY, layers, this.layerGroups);
    }

    public List<LayerGroup> getLayerGroups() {
        return this.layerGroups;
    }

    public VisualLayout withLayerGroups(List<LayerGroup> layerGroups) {
        return new VisualLayout(this.getName(), this.getProperties(), this.getHistory(), this.scaleX, this.scaleY, this.layers, layerGroups);
    }
}

