/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model.visualization;

import java.io.Serializable;
import java.util.Objects;

public class Layer
implements Serializable {
    private final int id;
    private final int ordinal;
    private final boolean visible;
    private final String name;
    private final int groupId;

    public Layer(int id, int ordinal, boolean visible, String name, int groupId) {
        this.id = id;
        this.ordinal = ordinal;
        this.visible = visible;
        this.name = Objects.requireNonNull(name, "name");
        this.groupId = groupId;
    }

    public int getId() {
        return this.id;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public Layer withOrdinal(int ordinal) {
        return new Layer(this.id, ordinal, this.visible, this.name, this.groupId);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Layer withVisible(boolean visible) {
        return new Layer(this.id, this.ordinal, visible, this.name, this.groupId);
    }

    public String getName() {
        return this.name;
    }

    public Layer withName(String name) {
        return new Layer(this.id, this.ordinal, this.visible, name, this.groupId);
    }

    public int getGroupId() {
        return this.groupId;
    }

    public Layer withGroupId(int groupId) {
        return new Layer(this.id, this.ordinal, this.visible, this.name, groupId);
    }

    public String toString() {
        return "Layer{id=" + this.id + ", ordinal=" + this.ordinal + ", visible=" + this.visible + ", name=" + this.name + ", groupId=" + this.groupId + "}";
    }
}

