/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import org.opentcs.data.model.Triple;
import org.opentcs.util.Assertions;

public class Pose
implements Serializable {
    private final Triple position;
    private final double orientationAngle;

    public Pose(@Nonnull Triple position, double orientationAngle) {
        this.position = Objects.requireNonNull(position, "position");
        Assertions.checkArgument(Double.isNaN(orientationAngle) || orientationAngle >= -360.0 && orientationAngle <= 360.0, "orientationAngle not Double.NaN or in [-360..360]: %s", orientationAngle);
        this.orientationAngle = orientationAngle;
    }

    @Nonnull
    public Triple getPosition() {
        return this.position;
    }

    public Pose withPosition(@Nonnull Triple position) {
        return new Pose(position, this.orientationAngle);
    }

    public double getOrientationAngle() {
        return this.orientationAngle;
    }

    public Pose withOrientationAngle(double orientationAngle) {
        return new Pose(this.position, orientationAngle);
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + Objects.hashCode(this.position);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.orientationAngle) ^ Double.doubleToLongBits(this.orientationAngle) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Pose)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Pose other = (Pose)obj;
        if (Double.doubleToLongBits(this.orientationAngle) != Double.doubleToLongBits(other.orientationAngle)) {
            return false;
        }
        return Objects.equals(this.position, other.position);
    }

    public String toString() {
        return "Pose{position=" + String.valueOf(this.position) + ", orientationAngle=" + this.orientationAngle + "}";
    }
}

