/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opentcs.data.model.Block;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.LocationType;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.data.model.visualization.LayerGroup;
import org.opentcs.data.model.visualization.VisualLayout;

public class PlantModel
implements Serializable {
    private final String name;
    private final Map<String, String> properties;
    private final Set<Point> points;
    private final Set<Path> paths;
    private final Set<LocationType> locationTypes;
    private final Set<Location> locations;
    private final Set<Block> blocks;
    private final Set<Vehicle> vehicles;
    private final VisualLayout visualLayout;

    public PlantModel(@Nonnull String name) {
        this(name, Map.of(), Set.of(), Set.of(), Set.of(), Set.of(), Set.of(), Set.of(), PlantModel.defaultVisualLayout());
    }

    private PlantModel(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull Set<Point> points, @Nonnull Set<Path> paths, @Nonnull Set<LocationType> locationTypes, @Nonnull Set<Location> locations, @Nonnull Set<Block> blocks, @Nonnull Set<Vehicle> vehicles, @Nonnull VisualLayout visualLayout) {
        this.name = Objects.requireNonNull(name, "name");
        this.properties = Map.copyOf(properties);
        this.points = Set.copyOf(points);
        this.paths = Set.copyOf(paths);
        this.locationTypes = Set.copyOf(locationTypes);
        this.locations = Set.copyOf(locations);
        this.blocks = Set.copyOf(blocks);
        this.vehicles = Set.copyOf(vehicles);
        this.visualLayout = Objects.requireNonNull(visualLayout, "visualLayout");
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public PlantModel withProperties(Map<String, String> properties) {
        return new PlantModel(this.name, properties, this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    @Nonnull
    public Set<Point> getPoints() {
        return this.points;
    }

    public PlantModel withPoints(@Nonnull Set<Point> points) {
        return new PlantModel(this.name, this.properties, points, this.paths, this.locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    @Nonnull
    public Set<Path> getPaths() {
        return this.paths;
    }

    public PlantModel withPaths(@Nonnull Set<Path> paths) {
        return new PlantModel(this.name, this.properties, this.points, paths, this.locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    @Nonnull
    public Set<LocationType> getLocationTypes() {
        return this.locationTypes;
    }

    public PlantModel withLocationTypes(@Nonnull Set<LocationType> locationTypes) {
        return new PlantModel(this.name, this.properties, this.points, this.paths, locationTypes, this.locations, this.blocks, this.vehicles, this.visualLayout);
    }

    @Nonnull
    public Set<Location> getLocations() {
        return this.locations;
    }

    public PlantModel withLocations(@Nonnull Set<Location> locations) {
        return new PlantModel(this.name, this.properties, this.points, this.paths, this.locationTypes, locations, this.blocks, this.vehicles, this.visualLayout);
    }

    @Nonnull
    public Set<Block> getBlocks() {
        return this.blocks;
    }

    public PlantModel withBlocks(@Nonnull Set<Block> blocks) {
        return new PlantModel(this.name, this.properties, this.points, this.paths, this.locationTypes, this.locations, blocks, this.vehicles, this.visualLayout);
    }

    @Nonnull
    public Set<Vehicle> getVehicles() {
        return this.vehicles;
    }

    public PlantModel withVehicles(@Nonnull Set<Vehicle> vehicles) {
        return new PlantModel(this.name, this.properties, this.points, this.paths, this.locationTypes, this.locations, this.blocks, vehicles, this.visualLayout);
    }

    @Nonnull
    public VisualLayout getVisualLayout() {
        return this.visualLayout;
    }

    public PlantModel withVisualLayout(@Nonnull VisualLayout visualLayout) {
        return new PlantModel(this.name, this.properties, this.points, this.paths, this.locationTypes, this.locations, this.blocks, this.vehicles, visualLayout);
    }

    public String toString() {
        return "PlantModel{name=" + this.name + ", properties=" + String.valueOf(this.properties) + ", points=" + String.valueOf(this.points) + ", paths=" + String.valueOf(this.paths) + ", locationTypes=" + String.valueOf(this.locationTypes) + ", locations=" + String.valueOf(this.locations) + ", blocks=" + String.valueOf(this.blocks) + ", vehicles=" + String.valueOf(this.vehicles) + ", visualLayout=" + String.valueOf(this.visualLayout) + "}";
    }

    private static VisualLayout defaultVisualLayout() {
        return new VisualLayout("VLayout").withLayers(List.of(new Layer(0, 0, true, "Default layer", 0))).withLayerGroups(List.of(new LayerGroup(0, "Default layer group", true)));
    }
}

