/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Couple;
import org.opentcs.data.model.Envelope;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.peripherals.PeripheralOperation;
import org.opentcs.util.Assertions;

public class Path
extends TCSResource<Path>
implements Serializable {
    private final TCSObjectReference<Point> sourcePoint;
    private final TCSObjectReference<Point> destinationPoint;
    private final long length;
    private final int maxVelocity;
    private final int maxReverseVelocity;
    private final List<PeripheralOperation> peripheralOperations;
    private final boolean locked;
    private final Map<String, Envelope> vehicleEnvelopes;
    private final Layout layout;

    public Path(String name, TCSObjectReference<Point> sourcePoint, TCSObjectReference<Point> destinationPoint) {
        super(name);
        this.sourcePoint = Objects.requireNonNull(sourcePoint, "sourcePoint");
        this.destinationPoint = Objects.requireNonNull(destinationPoint, "destinationPoint");
        this.length = 1L;
        this.maxVelocity = 1000;
        this.maxReverseVelocity = 1000;
        this.peripheralOperations = List.of();
        this.locked = false;
        this.vehicleEnvelopes = Map.of();
        this.layout = new Layout();
    }

    private Path(String name, Map<String, String> properties, ObjectHistory history, TCSObjectReference<Point> sourcePoint, TCSObjectReference<Point> destinationPoint, long length, int maxVelocity, int maxReverseVelocity, List<PeripheralOperation> peripheralOperations, boolean locked, Map<String, Envelope> vehicleEnvelopes, Layout layout) {
        super(name, properties, history);
        this.sourcePoint = Objects.requireNonNull(sourcePoint, "sourcePoint");
        this.destinationPoint = Objects.requireNonNull(destinationPoint, "destinationPoint");
        this.length = Assertions.checkInRange(length, 1L, Long.MAX_VALUE, "length");
        this.maxVelocity = Assertions.checkInRange(maxVelocity, 0, Integer.MAX_VALUE, "maxVelocity");
        this.maxReverseVelocity = Assertions.checkInRange(maxReverseVelocity, 0, Integer.MAX_VALUE, "maxReverseVelocity");
        this.peripheralOperations = new ArrayList<PeripheralOperation>((Collection)Objects.requireNonNull(peripheralOperations, "peripheralOperations"));
        this.locked = locked;
        this.vehicleEnvelopes = Objects.requireNonNull(vehicleEnvelopes, "vehicleEnvelopes");
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    public Path withProperty(String key, String value) {
        return new Path(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.sourcePoint, this.destinationPoint, this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public Path withProperties(Map<String, String> properties) {
        return new Path(this.getName(), properties, this.getHistory(), this.sourcePoint, this.destinationPoint, this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    @Override
    public TCSObject<Path> withHistoryEntry(ObjectHistory.Entry entry) {
        return new Path(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.sourcePoint, this.destinationPoint, this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    @Override
    public TCSObject<Path> withHistory(ObjectHistory history) {
        return new Path(this.getName(), this.getProperties(), history, this.sourcePoint, this.destinationPoint, this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public long getLength() {
        return this.length;
    }

    public Path withLength(long length) {
        return new Path(this.getName(), this.getProperties(), this.getHistory(), this.sourcePoint, this.destinationPoint, length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public TCSObjectReference<Point> getSourcePoint() {
        return this.sourcePoint;
    }

    public TCSObjectReference<Point> getDestinationPoint() {
        return this.destinationPoint;
    }

    public int getMaxVelocity() {
        return this.maxVelocity;
    }

    public Path withMaxVelocity(int maxVelocity) {
        return new Path(this.getName(), this.getProperties(), this.getHistory(), this.sourcePoint, this.destinationPoint, this.length, maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public int getMaxReverseVelocity() {
        return this.maxReverseVelocity;
    }

    public Path withMaxReverseVelocity(int maxReverseVelocity) {
        return new Path(this.getName(), this.getProperties(), this.getHistory(), this.sourcePoint, this.destinationPoint, this.length, this.maxVelocity, maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public List<PeripheralOperation> getPeripheralOperations() {
        return Collections.unmodifiableList(this.peripheralOperations);
    }

    public Path withPeripheralOperations(@Nonnull List<PeripheralOperation> peripheralOperations) {
        return new Path(this.getName(), this.getProperties(), this.getHistory(), this.sourcePoint, this.destinationPoint, this.length, this.maxVelocity, this.maxReverseVelocity, peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Path withLocked(boolean locked) {
        return new Path(this.getName(), this.getProperties(), this.getHistory(), this.sourcePoint, this.destinationPoint, this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, locked, this.vehicleEnvelopes, this.layout);
    }

    public Map<String, Envelope> getVehicleEnvelopes() {
        return this.vehicleEnvelopes;
    }

    public Path withVehicleEnvelopes(Map<String, Envelope> vehicleEnvelopes) {
        return new Path(this.getName(), this.getProperties(), this.getHistory(), this.sourcePoint, this.destinationPoint, this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, vehicleEnvelopes, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Path withLayout(Layout layout) {
        return new Path(this.getName(), this.getProperties(), this.getHistory(), this.sourcePoint, this.destinationPoint, this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, layout);
    }

    public boolean isNavigableForward() {
        return !this.locked && this.maxVelocity != 0;
    }

    public boolean isNavigableReverse() {
        return !this.locked && this.maxReverseVelocity != 0;
    }

    public boolean isNavigableTo(TCSObjectReference<Point> navPoint) throws IllegalArgumentException {
        if (Objects.equals(navPoint, this.destinationPoint)) {
            return this.isNavigableForward();
        }
        if (Objects.equals(navPoint, this.sourcePoint)) {
            return this.isNavigableReverse();
        }
        throw new IllegalArgumentException(String.valueOf(navPoint) + " is not an end point of " + String.valueOf(this));
    }

    public static class Layout
    implements Serializable {
        private final ConnectionType connectionType;
        private final List<Couple> controlPoints;
        private final int layerId;

        public Layout() {
            this(ConnectionType.DIRECT, new ArrayList<Couple>(), 0);
        }

        public Layout(ConnectionType connectionType, List<Couple> controlPoints, int layerId) {
            this.connectionType = connectionType;
            this.controlPoints = Objects.requireNonNull(controlPoints, "controlPoints");
            this.layerId = layerId;
        }

        public ConnectionType getConnectionType() {
            return this.connectionType;
        }

        public Layout withConnectionType(ConnectionType connectionType) {
            return new Layout(connectionType, this.controlPoints, this.layerId);
        }

        public List<Couple> getControlPoints() {
            return Collections.unmodifiableList(this.controlPoints);
        }

        public Layout withControlPoints(List<Couple> controlPoints) {
            return new Layout(this.connectionType, controlPoints, this.layerId);
        }

        public int getLayerId() {
            return this.layerId;
        }

        public Layout withLayer(int layerId) {
            return new Layout(this.connectionType, this.controlPoints, layerId);
        }

        public static enum ConnectionType {
            DIRECT,
            ELBOW,
            SLANTED,
            POLYPATH,
            BEZIER,
            BEZIER_3;

        }
    }
}

