/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.model;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.model.TCSResourceReference;

public class Block
extends TCSResource<Block>
implements Serializable {
    private final Type type;
    private final Set<TCSResourceReference<?>> members;
    private final Layout layout;

    public Block(String name) {
        super(name);
        this.type = Type.SINGLE_VEHICLE_ONLY;
        this.members = new HashSet();
        this.layout = new Layout();
    }

    private Block(String name, Map<String, String> properties, ObjectHistory history, Type type, Set<TCSResourceReference<?>> members, Layout layout) {
        super(name, properties, history);
        this.type = type;
        this.members = new HashSet((Collection)Objects.requireNonNull(members, "members"));
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    public Block withProperty(String key, String value) {
        return new Block(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.type, this.members, this.layout);
    }

    public Block withProperties(Map<String, String> properties) {
        return new Block(this.getName(), properties, this.getHistory(), this.type, this.members, this.layout);
    }

    @Override
    public TCSObject<Block> withHistoryEntry(ObjectHistory.Entry entry) {
        return new Block(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.type, this.members, this.layout);
    }

    @Override
    public TCSObject<Block> withHistory(ObjectHistory history) {
        return new Block(this.getName(), this.getProperties(), history, this.type, this.members, this.layout);
    }

    public Type getType() {
        return this.type;
    }

    public Block withType(Type type) {
        return new Block(this.getName(), this.getProperties(), this.getHistory(), type, this.members, this.layout);
    }

    public Set<TCSResourceReference<?>> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public Block withMembers(Set<TCSResourceReference<?>> members) {
        return new Block(this.getName(), this.getProperties(), this.getHistory(), this.type, members, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Block withLayout(Layout layout) {
        return new Block(this.getName(), this.getProperties(), this.getHistory(), this.type, this.members, layout);
    }

    public static enum Type {
        SINGLE_VEHICLE_ONLY,
        SAME_DIRECTION_ONLY;

    }

    public static class Layout
    implements Serializable {
        private final Color color;

        public Layout() {
            this(Color.RED);
        }

        public Layout(Color color) {
            this.color = Objects.requireNonNull(color, "color");
        }

        public Color getColor() {
            return this.color;
        }

        public Layout withColor(Color color) {
            return new Layout(color);
        }
    }
}

