/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.model;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentcs.access.to.CreationTO;
import org.opentcs.access.to.peripherals.PeripheralOperationCreationTO;
import org.opentcs.data.model.Couple;
import org.opentcs.data.model.Envelope;
import org.opentcs.data.model.Path;
import org.opentcs.util.Assertions;

public class PathCreationTO
extends CreationTO
implements Serializable {
    @Nonnull
    private final String srcPointName;
    @Nonnull
    private final String destPointName;
    private final long length;
    private final int maxVelocity;
    private final int maxReverseVelocity;
    private final List<PeripheralOperationCreationTO> peripheralOperations;
    private final boolean locked;
    private final Map<String, Envelope> vehicleEnvelopes;
    private final Layout layout;

    public PathCreationTO(@Nonnull String name, @Nonnull String srcPointName, @Nonnull String destPointName) {
        super(name);
        this.srcPointName = Objects.requireNonNull(srcPointName, "srcPointName");
        this.destPointName = Objects.requireNonNull(destPointName, "destPointName");
        this.length = 1L;
        this.maxVelocity = 0;
        this.maxReverseVelocity = 0;
        this.peripheralOperations = List.of();
        this.locked = false;
        this.vehicleEnvelopes = Map.of();
        this.layout = new Layout();
    }

    private PathCreationTO(String name, @Nonnull String srcPointName, @Nonnull String destPointName, @Nonnull Map<String, String> properties, long length, int maxVelocity, int maxReverseVelocity, List<PeripheralOperationCreationTO> peripheralOperations, boolean locked, @Nonnull Map<String, Envelope> vehicleEnvelopes, @Nonnull Layout layout) {
        super(name, properties);
        this.srcPointName = Objects.requireNonNull(srcPointName, "srcPointName");
        this.destPointName = Objects.requireNonNull(destPointName, "destPointName");
        this.length = length;
        this.maxVelocity = maxVelocity;
        this.maxReverseVelocity = maxReverseVelocity;
        this.peripheralOperations = new ArrayList<PeripheralOperationCreationTO>((Collection)Objects.requireNonNull(peripheralOperations, "peripheralOperations"));
        this.locked = locked;
        this.vehicleEnvelopes = Objects.requireNonNull(vehicleEnvelopes, "vehicleEnvelopes");
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    @Override
    public PathCreationTO withName(@Nonnull String name) {
        return new PathCreationTO(name, this.srcPointName, this.destPointName, this.getModifiableProperties(), this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    @Nonnull
    public String getSrcPointName() {
        return this.srcPointName;
    }

    public PathCreationTO withSrcPointName(@Nonnull String srcPointName) {
        return new PathCreationTO(this.getName(), srcPointName, this.destPointName, this.getModifiableProperties(), this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    @Nonnull
    public String getDestPointName() {
        return this.destPointName;
    }

    public PathCreationTO withDestPointName(@Nonnull String destPointName) {
        return new PathCreationTO(this.getName(), this.srcPointName, destPointName, this.getModifiableProperties(), this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public long getLength() {
        return this.length;
    }

    public PathCreationTO withLength(long length) {
        Assertions.checkArgument(length > 0L, "length must be a positive value: " + length);
        return new PathCreationTO(this.getName(), this.srcPointName, this.destPointName, this.getModifiableProperties(), length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public int getMaxVelocity() {
        return this.maxVelocity;
    }

    public PathCreationTO withMaxVelocity(int maxVelocity) {
        Assertions.checkArgument(maxVelocity >= 0, "maxVelocity may not be a negative value: " + maxVelocity);
        return new PathCreationTO(this.getName(), this.srcPointName, this.destPointName, this.getModifiableProperties(), this.length, maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public int getMaxReverseVelocity() {
        return this.maxReverseVelocity;
    }

    public PathCreationTO withMaxReverseVelocity(int maxReverseVelocity) {
        Assertions.checkArgument(maxReverseVelocity >= 0, "maxReverseVelocity may not be a negative value: " + maxReverseVelocity);
        return new PathCreationTO(this.getName(), this.srcPointName, this.destPointName, this.getModifiableProperties(), this.length, this.maxVelocity, maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public List<PeripheralOperationCreationTO> getPeripheralOperations() {
        return Collections.unmodifiableList(this.peripheralOperations);
    }

    public PathCreationTO withPeripheralOperations(@Nonnull List<PeripheralOperationCreationTO> peripheralOperations) {
        return new PathCreationTO(this.getName(), this.srcPointName, this.destPointName, this.getModifiableProperties(), this.length, this.maxVelocity, this.maxReverseVelocity, peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public PathCreationTO withLocked(boolean locked) {
        return new PathCreationTO(this.getName(), this.srcPointName, this.destPointName, this.getModifiableProperties(), this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, locked, this.vehicleEnvelopes, this.layout);
    }

    @Override
    public PathCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new PathCreationTO(this.getName(), this.srcPointName, this.destPointName, properties, this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    @Override
    public PathCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new PathCreationTO(this.getName(), this.srcPointName, this.destPointName, this.propertiesWith(key, value), this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, this.layout);
    }

    public Map<String, Envelope> getVehicleEnvelopes() {
        return this.vehicleEnvelopes;
    }

    public PathCreationTO withVehicleEnvelopes(@Nonnull Map<String, Envelope> vehicleEnvelopes) {
        return new PathCreationTO(this.getName(), this.srcPointName, this.destPointName, this.getModifiableProperties(), this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, vehicleEnvelopes, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public PathCreationTO withLayout(Layout layout) {
        return new PathCreationTO(this.getName(), this.srcPointName, this.destPointName, this.getModifiableProperties(), this.length, this.maxVelocity, this.maxReverseVelocity, this.peripheralOperations, this.locked, this.vehicleEnvelopes, layout);
    }

    public String toString() {
        return "PathCreationTO{name=" + this.getName() + ", srcPointName=" + this.srcPointName + ", destPointName=" + this.destPointName + ", length=" + this.length + ", maxVelocity=" + this.maxVelocity + ", maxReverseVelocity=" + this.maxReverseVelocity + ", peripheralOperations=" + String.valueOf(this.peripheralOperations) + ", locked=" + this.locked + ", layout=" + String.valueOf(this.layout) + ", vehicleEnvelopes=" + String.valueOf(this.vehicleEnvelopes) + ", properties=" + String.valueOf(this.getProperties()) + "}";
    }

    public static class Layout
    implements Serializable {
        private final Path.Layout.ConnectionType connectionType;
        private final List<Couple> controlPoints;
        private final int layerId;

        public Layout() {
            this(Path.Layout.ConnectionType.DIRECT, new ArrayList<Couple>(), 0);
        }

        public Layout(Path.Layout.ConnectionType connectionType, List<Couple> controlPoints, int layerId) {
            this.connectionType = connectionType;
            this.controlPoints = Objects.requireNonNull(controlPoints, "controlPoints");
            this.layerId = layerId;
        }

        public Path.Layout.ConnectionType getConnectionType() {
            return this.connectionType;
        }

        public Layout withConnectionType(Path.Layout.ConnectionType connectionType) {
            return new Layout(connectionType, this.controlPoints, this.layerId);
        }

        public List<Couple> getControlPoints() {
            return Collections.unmodifiableList(this.controlPoints);
        }

        public Layout withControlPoints(List<Couple> controlPoints) {
            return new Layout(this.connectionType, controlPoints, this.layerId);
        }

        public int getLayerId() {
            return this.layerId;
        }

        public Layout withLayer(int layerId) {
            return new Layout(this.connectionType, this.controlPoints, layerId);
        }

        public String toString() {
            return "Layout{connectionType=" + String.valueOf((Object)this.connectionType) + ", controlPoints=" + String.valueOf(this.controlPoints) + ", layerId=" + this.layerId + "}";
        }
    }
}

