/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.to.model;

import jakarta.annotation.Nonnull;
import java.awt.Color;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opentcs.access.to.CreationTO;
import org.opentcs.data.model.Block;

public class BlockCreationTO
extends CreationTO
implements Serializable {
    @Nonnull
    private final Block.Type type;
    @Nonnull
    private final Set<String> memberNames;
    private final Layout layout;

    public BlockCreationTO(String name) {
        super(name);
        this.type = Block.Type.SINGLE_VEHICLE_ONLY;
        this.memberNames = Set.of();
        this.layout = new Layout();
    }

    private BlockCreationTO(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull Block.Type type, @Nonnull Set<String> memberNames, @Nonnull Layout layout) {
        super(name, properties);
        this.type = Objects.requireNonNull(type, "type");
        this.memberNames = Objects.requireNonNull(memberNames, "memberNames");
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    @Override
    public BlockCreationTO withName(@Nonnull String name) {
        return new BlockCreationTO(name, this.getModifiableProperties(), this.type, this.memberNames, this.layout);
    }

    @Override
    public BlockCreationTO withProperties(@Nonnull Map<String, String> properties) {
        return new BlockCreationTO(this.getName(), properties, this.type, this.memberNames, this.layout);
    }

    @Override
    public BlockCreationTO withProperty(@Nonnull String key, @Nonnull String value) {
        return new BlockCreationTO(this.getName(), this.propertiesWith(key, value), this.type, this.memberNames, this.layout);
    }

    @Nonnull
    public Block.Type getType() {
        return this.type;
    }

    public BlockCreationTO withType(@Nonnull Block.Type type) {
        return new BlockCreationTO(this.getName(), this.getModifiableProperties(), type, this.memberNames, this.layout);
    }

    @Nonnull
    public Set<String> getMemberNames() {
        return Collections.unmodifiableSet(this.memberNames);
    }

    public BlockCreationTO withMemberNames(@Nonnull Set<String> memberNames) {
        return new BlockCreationTO(this.getName(), this.getModifiableProperties(), this.type, memberNames, this.layout);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public BlockCreationTO withLayout(Layout layout) {
        return new BlockCreationTO(this.getName(), this.getModifiableProperties(), this.type, this.memberNames, layout);
    }

    public String toString() {
        return "BlockCreationTO{name=" + this.getName() + ", type=" + String.valueOf((Object)this.type) + ", memberNames=" + String.valueOf(this.memberNames) + ", layout=" + String.valueOf(this.layout) + ", properties=" + String.valueOf(this.getProperties()) + "}";
    }

    public static class Layout
    implements Serializable {
        private final Color color;

        public Layout() {
            this(Color.RED);
        }

        public Layout(Color color) {
            this.color = Objects.requireNonNull(color, "color");
        }

        public Color getColor() {
            return this.color;
        }

        public Layout withColor(Color color) {
            return new Layout(color);
        }

        public String toString() {
            return "Layout{color=" + String.valueOf(this.color) + "}";
        }
    }
}

