/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.services;

import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.rmi.services.AbstractRemoteServiceProxy;
import org.opentcs.access.rmi.services.RemoteRouterService;
import org.opentcs.components.kernel.services.RouterService;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.Route;

class RemoteRouterServiceProxy
extends AbstractRemoteServiceProxy<RemoteRouterService>
implements RouterService {
    RemoteRouterServiceProxy() {
    }

    @Override
    public void updateRoutingTopology(Set<TCSObjectReference<Path>> refs) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteRouterService)this.getRemoteService()).updateRoutingTopology(this.getClientId(), refs);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public Map<TCSObjectReference<Point>, Route> computeRoutes(TCSObjectReference<Vehicle> vehicleRef, TCSObjectReference<Point> sourcePointRef, Set<TCSObjectReference<Point>> destinationPointRefs, Set<TCSResourceReference<?>> resourcesToAvoid) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteRouterService)this.getRemoteService()).computeRoutes(this.getClientId(), vehicleRef, sourcePointRef, destinationPointRefs, resourcesToAvoid);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }
}

