/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.services;

import java.rmi.RemoteException;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.rmi.services.RemotePeripheralService;
import org.opentcs.access.rmi.services.RemoteTCSObjectServiceProxy;
import org.opentcs.components.kernel.services.PeripheralService;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.drivers.peripherals.PeripheralAdapterCommand;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterDescription;
import org.opentcs.drivers.peripherals.PeripheralProcessModel;
import org.opentcs.drivers.peripherals.management.PeripheralAttachmentInformation;

class RemotePeripheralServiceProxy
extends RemoteTCSObjectServiceProxy<RemotePeripheralService>
implements PeripheralService {
    RemotePeripheralServiceProxy() {
    }

    @Override
    public void attachCommAdapter(TCSResourceReference<Location> ref, PeripheralCommAdapterDescription description) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemotePeripheralService)this.getRemoteService()).attachCommAdapter(this.getClientId(), ref, description);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void disableCommAdapter(TCSResourceReference<Location> ref) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemotePeripheralService)this.getRemoteService()).disableCommAdapter(this.getClientId(), ref);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void enableCommAdapter(TCSResourceReference<Location> ref) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemotePeripheralService)this.getRemoteService()).enableCommAdapter(this.getClientId(), ref);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public PeripheralAttachmentInformation fetchAttachmentInformation(TCSResourceReference<Location> ref) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemotePeripheralService)this.getRemoteService()).fetchAttachmentInformation(this.getClientId(), ref);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public PeripheralProcessModel fetchProcessModel(TCSResourceReference<Location> ref) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemotePeripheralService)this.getRemoteService()).fetchProcessModel(this.getClientId(), ref);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void sendCommAdapterCommand(TCSResourceReference<Location> ref, PeripheralAdapterCommand command) throws ObjectUnknownException, KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemotePeripheralService)this.getRemoteService()).sendCommAdapterCommand(this.getClientId(), ref, command);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }
}

