/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.services;

import java.rmi.RemoteException;
import java.util.List;
import java.util.function.Predicate;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.rmi.services.AbstractRemoteServiceProxy;
import org.opentcs.access.rmi.services.RemoteNotificationService;
import org.opentcs.components.kernel.services.NotificationService;
import org.opentcs.data.notification.UserNotification;

class RemoteNotificationServiceProxy
extends AbstractRemoteServiceProxy<RemoteNotificationService>
implements NotificationService {
    RemoteNotificationServiceProxy() {
    }

    @Override
    public List<UserNotification> fetchUserNotifications(Predicate<UserNotification> predicate) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteNotificationService)this.getRemoteService()).fetchUserNotifications(this.getClientId(), predicate);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void publishUserNotification(UserNotification notification) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteNotificationService)this.getRemoteService()).publishUserNotification(this.getClientId(), notification);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }
}

