/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.services;

import jakarta.annotation.Nonnull;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.opentcs.access.CredentialsException;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.rmi.factories.SocketFactoryProvider;
import org.opentcs.access.rmi.services.AbstractRemoteServiceProxy;
import org.opentcs.access.rmi.services.RegistrationName;
import org.opentcs.access.rmi.services.RemoteDispatcherService;
import org.opentcs.access.rmi.services.RemoteDispatcherServiceProxy;
import org.opentcs.access.rmi.services.RemoteKernelServicePortal;
import org.opentcs.access.rmi.services.RemoteNotificationService;
import org.opentcs.access.rmi.services.RemoteNotificationServiceProxy;
import org.opentcs.access.rmi.services.RemotePeripheralDispatcherService;
import org.opentcs.access.rmi.services.RemotePeripheralDispatcherServiceProxy;
import org.opentcs.access.rmi.services.RemotePeripheralJobService;
import org.opentcs.access.rmi.services.RemotePeripheralJobServiceProxy;
import org.opentcs.access.rmi.services.RemotePeripheralService;
import org.opentcs.access.rmi.services.RemotePeripheralServiceProxy;
import org.opentcs.access.rmi.services.RemotePlantModelService;
import org.opentcs.access.rmi.services.RemotePlantModelServiceProxy;
import org.opentcs.access.rmi.services.RemoteQueryService;
import org.opentcs.access.rmi.services.RemoteQueryServiceProxy;
import org.opentcs.access.rmi.services.RemoteRouterService;
import org.opentcs.access.rmi.services.RemoteRouterServiceProxy;
import org.opentcs.access.rmi.services.RemoteTransportOrderService;
import org.opentcs.access.rmi.services.RemoteTransportOrderServiceProxy;
import org.opentcs.access.rmi.services.RemoteVehicleService;
import org.opentcs.access.rmi.services.RemoteVehicleServiceProxy;
import org.opentcs.access.rmi.services.ServiceListener;
import org.opentcs.components.kernel.services.DispatcherService;
import org.opentcs.components.kernel.services.NotificationService;
import org.opentcs.components.kernel.services.PeripheralDispatcherService;
import org.opentcs.components.kernel.services.PeripheralJobService;
import org.opentcs.components.kernel.services.PeripheralService;
import org.opentcs.components.kernel.services.PlantModelService;
import org.opentcs.components.kernel.services.QueryService;
import org.opentcs.components.kernel.services.RouterService;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.components.kernel.services.TransportOrderService;
import org.opentcs.components.kernel.services.VehicleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteKernelServicePortalProxy
extends AbstractRemoteServiceProxy<RemoteKernelServicePortal>
implements KernelServicePortal,
ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteKernelServicePortalProxy.class);
    private final String userName;
    private final String password;
    private final SocketFactoryProvider socketFactoryProvider;
    private final Predicate<Object> eventFilter;
    private final RemotePlantModelServiceProxy plantModelService = new RemotePlantModelServiceProxy();
    private final RemoteTransportOrderServiceProxy transportOrderService = new RemoteTransportOrderServiceProxy();
    private final RemoteVehicleServiceProxy vehicleService = new RemoteVehicleServiceProxy();
    private final RemoteNotificationServiceProxy notificationService = new RemoteNotificationServiceProxy();
    private final RemoteDispatcherServiceProxy dispatcherService = new RemoteDispatcherServiceProxy();
    private final RemoteRouterServiceProxy routerService = new RemoteRouterServiceProxy();
    private final RemoteQueryServiceProxy queryService = new RemoteQueryServiceProxy();
    private final RemotePeripheralServiceProxy peripheralService = new RemotePeripheralServiceProxy();
    private final RemotePeripheralJobServiceProxy peripheralJobService = new RemotePeripheralJobServiceProxy();
    private final RemotePeripheralDispatcherServiceProxy peripheralDispatcherService = new RemotePeripheralDispatcherServiceProxy();

    public RemoteKernelServicePortalProxy(@Nonnull String userName, @Nonnull String password, @Nonnull SocketFactoryProvider socketFactoryProvider, @Nonnull Predicate<Object> eventFilter) {
        this.userName = Objects.requireNonNull(userName, "userName");
        this.password = Objects.requireNonNull(password, "password");
        this.socketFactoryProvider = Objects.requireNonNull(socketFactoryProvider, "socketFactoryProvider");
        this.eventFilter = Objects.requireNonNull(eventFilter, "eventFilter");
    }

    @Override
    public ServiceListener getServiceListener() {
        return this;
    }

    @Override
    public void onServiceUnavailable() {
        this.resetServiceLogins();
    }

    @Override
    public void login(@Nonnull String hostName, int port) throws CredentialsException, ServiceUnavailableException {
        Objects.requireNonNull(hostName, "hostName");
        if (this.isLoggedIn()) {
            LOG.warn("Already logged in, doing nothing.");
            return;
        }
        try {
            Registry registry = LocateRegistry.getRegistry(hostName, port, this.socketFactoryProvider.getClientSocketFactory());
            this.setRemoteService((RemoteKernelServicePortal)registry.lookup(RegistrationName.REMOTE_KERNEL_CLIENT_PORTAL));
            this.setClientId(((RemoteKernelServicePortal)this.getRemoteService()).login(this.userName, this.password, this.eventFilter));
            this.setServiceListener(this);
            this.updateServiceLogins(registry);
        }
        catch (NotBoundException | RemoteException exc) {
            this.resetServiceLogins();
            throw new ServiceUnavailableException("Exception logging in with remote kernel client portal", exc);
        }
    }

    @Override
    public void logout() {
        if (!this.isLoggedIn()) {
            LOG.warn("Not logged in, doing nothing.");
            return;
        }
        try {
            ((RemoteKernelServicePortal)this.getRemoteService()).logout(this.getClientId());
        }
        catch (RemoteException ex) {
            throw new ServiceUnavailableException("Remote kernel client portal unavailable", ex);
        }
        this.resetServiceLogins();
    }

    @Override
    public Kernel.State getState() throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteKernelServicePortal)this.getRemoteService()).getState(this.getClientId());
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public List<Object> fetchEvents(long timeout) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            return ((RemoteKernelServicePortal)this.getRemoteService()).fetchEvents(this.getClientId(), timeout);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    public void publishEvent(Object event) throws KernelRuntimeException {
        this.checkServiceAvailability();
        try {
            ((RemoteKernelServicePortal)this.getRemoteService()).publishEvent(this.getClientId(), event);
        }
        catch (RemoteException ex) {
            throw this.findSuitableExceptionFor(ex);
        }
    }

    @Override
    @Nonnull
    public PlantModelService getPlantModelService() {
        return this.plantModelService;
    }

    @Override
    @Nonnull
    public TransportOrderService getTransportOrderService() {
        return this.transportOrderService;
    }

    @Override
    @Nonnull
    public VehicleService getVehicleService() {
        return this.vehicleService;
    }

    @Override
    @Nonnull
    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    @Override
    @Nonnull
    public DispatcherService getDispatcherService() {
        return this.dispatcherService;
    }

    @Override
    @Nonnull
    public RouterService getRouterService() {
        return this.routerService;
    }

    @Override
    @Nonnull
    public QueryService getQueryService() {
        return this.queryService;
    }

    @Override
    @Nonnull
    public PeripheralService getPeripheralService() {
        return this.peripheralService;
    }

    @Override
    @Nonnull
    public PeripheralJobService getPeripheralJobService() {
        return this.peripheralJobService;
    }

    @Override
    @Nonnull
    public PeripheralDispatcherService getPeripheralDispatcherService() {
        return this.peripheralDispatcherService;
    }

    private void updateServiceLogins(Registry registry) throws RemoteException, NotBoundException {
        this.plantModelService.setClientId(this.getClientId()).setRemoteService((RemotePlantModelService)registry.lookup(RegistrationName.REMOTE_PLANT_MODEL_SERVICE)).setServiceListener(this);
        this.transportOrderService.setClientId(this.getClientId()).setRemoteService((RemoteTransportOrderService)registry.lookup(RegistrationName.REMOTE_TRANSPORT_ORDER_SERVICE)).setServiceListener(this);
        this.vehicleService.setClientId(this.getClientId()).setRemoteService((RemoteVehicleService)registry.lookup(RegistrationName.REMOTE_VEHICLE_SERVICE)).setServiceListener(this);
        this.notificationService.setClientId(this.getClientId()).setRemoteService((RemoteNotificationService)registry.lookup(RegistrationName.REMOTE_NOTIFICATION_SERVICE)).setServiceListener(this);
        this.dispatcherService.setClientId(this.getClientId()).setRemoteService((RemoteDispatcherService)registry.lookup(RegistrationName.REMOTE_DISPATCHER_SERVICE)).setServiceListener(this);
        this.routerService.setClientId(this.getClientId()).setRemoteService((RemoteRouterService)registry.lookup(RegistrationName.REMOTE_ROUTER_SERVICE)).setServiceListener(this);
        this.queryService.setClientId(this.getClientId()).setRemoteService((RemoteQueryService)registry.lookup(RegistrationName.REMOTE_QUERY_SERVICE)).setServiceListener(this);
        this.peripheralService.setClientId(this.getClientId()).setRemoteService((RemotePeripheralService)registry.lookup(RegistrationName.REMOTE_PERIPHERAL_SERVICE)).setServiceListener(this);
        this.peripheralJobService.setClientId(this.getClientId()).setRemoteService((RemotePeripheralJobService)registry.lookup(RegistrationName.REMOTE_PERIPHERAL_JOB_SERVICE)).setServiceListener(this);
        this.peripheralDispatcherService.setClientId(this.getClientId()).setRemoteService((RemotePeripheralDispatcherService)registry.lookup(RegistrationName.REMOTE_PERIPHERAL_DISPATCHER_SERVICE)).setServiceListener(this);
    }

    private void resetServiceLogins() {
        this.setClientId(null).setRemoteService(null).setServiceListener(null);
        this.plantModelService.setClientId(null).setRemoteService(null).setServiceListener(null);
        this.transportOrderService.setClientId(null).setRemoteService(null).setServiceListener(null);
        this.vehicleService.setClientId(null).setRemoteService(null).setServiceListener(null);
        this.notificationService.setClientId(null).setRemoteService(null).setServiceListener(null);
        this.dispatcherService.setClientId(null).setRemoteService(null).setServiceListener(null);
        this.routerService.setClientId(null).setRemoteService(null).setServiceListener(null);
        this.queryService.setClientId(null).setRemoteService(null).setServiceListener(null);
        this.peripheralService.setClientId(null).setRemoteService(null).setServiceListener(null);
        this.peripheralJobService.setClientId(null).setRemoteService(null).setServiceListener(null);
        this.peripheralDispatcherService.setClientId(null).setRemoteService(null).setServiceListener(null);
    }
}

