/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.factories;

import jakarta.inject.Inject;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.opentcs.access.SslParameterSet;
import org.opentcs.access.rmi.factories.CustomSslRMIClientSocketFactory;
import org.opentcs.access.rmi.factories.SecureSslContextFactory;
import org.opentcs.access.rmi.factories.SocketFactoryProvider;

public class SecureSocketFactoryProvider
implements SocketFactoryProvider {
    private final SecureSslContextFactory secureSslContextFactory;

    @Inject
    public SecureSocketFactoryProvider(SslParameterSet sslParameterSet) {
        Objects.requireNonNull(sslParameterSet, "sslParameterSet");
        this.secureSslContextFactory = new SecureSslContextFactory(sslParameterSet);
    }

    @Override
    public RMIClientSocketFactory getClientSocketFactory() {
        return new CustomSslRMIClientSocketFactory(this.secureSslContextFactory);
    }

    @Override
    public RMIServerSocketFactory getServerSocketFactory() {
        SSLContext context = this.secureSslContextFactory.createServerContext();
        SSLParameters param = context.getSupportedSSLParameters();
        return new SslRMIServerSocketFactory(context, param.getCipherSuites(), param.getProtocols(), param.getWantClientAuth());
    }
}

