/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi.factories;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.opentcs.access.rmi.factories.SecureSslContextFactory;

class CustomSslRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private final SecureSslContextFactory secureSslContextFactory;

    CustomSslRMIClientSocketFactory(SecureSslContextFactory secureSslContextFactory) {
        this.secureSslContextFactory = Objects.requireNonNull(secureSslContextFactory, "secureSslContextFactory");
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLContext context = this.secureSslContextFactory.createClientContext();
        SSLSocketFactory sf = context.getSocketFactory();
        SSLSocket socket = (SSLSocket)sf.createSocket(host, port);
        SSLParameters param = context.getSupportedSSLParameters();
        socket.setEnabledCipherSuites(param.getCipherSuites());
        socket.setEnabledProtocols(param.getProtocols());
        return socket;
    }
}

