/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.access.rmi;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Predicate;
import org.opentcs.access.CredentialsException;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.rmi.factories.NullSocketFactoryProvider;
import org.opentcs.access.rmi.factories.SocketFactoryProvider;
import org.opentcs.access.rmi.services.RemoteKernelServicePortalProxy;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.util.ClassMatcher;

public class KernelServicePortalBuilder {
    private SocketFactoryProvider socketFactoryProvider = new NullSocketFactoryProvider();
    private final String userName;
    private final String password;
    private Predicate<Object> eventFilter = new ClassMatcher(Object.class);

    public KernelServicePortalBuilder(String userName, String password) {
        this.userName = Objects.requireNonNull(userName, "userName");
        this.password = Objects.requireNonNull(password, "password");
    }

    public SocketFactoryProvider getSocketFactoryProvider() {
        return this.socketFactoryProvider;
    }

    public KernelServicePortalBuilder setSocketFactoryProvider(@Nonnull SocketFactoryProvider socketFactoryProvider) {
        this.socketFactoryProvider = Objects.requireNonNull(socketFactoryProvider, "socketFactoryProvider");
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Predicate<Object> getEventFilter() {
        return this.eventFilter;
    }

    public KernelServicePortalBuilder setEventFilter(@Nonnull Predicate<Object> eventFilter) {
        this.eventFilter = Objects.requireNonNull(eventFilter, "eventFilter");
        return this;
    }

    public KernelServicePortal build() throws ServiceUnavailableException, CredentialsException {
        return new RemoteKernelServicePortalProxy(this.userName, this.password, this.socketFactoryProvider, this.eventFilter);
    }
}

